/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.tapestry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.resolver.AbstractSpecificationResolver;
import org.apache.tapestry.spec.ComponentSpecification;
import org.apache.tapestry.spec.IComponentSpecification;

public class S2PageSpecificationResolver
extends AbstractSpecificationResolver {
    private static final Log LOG;
    private String _simpleName;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.tapestry.S2PageSpecificationResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public S2PageSpecificationResolver(IRequestCycle cycle) {
        super(cycle);
    }

    public void resolve(IRequestCycle cycle, String prefixedName) {
        this.reset();
        INamespace namespace = null;
        int colonx = prefixedName.indexOf(58);
        if (colonx > 0) {
            this._simpleName = prefixedName.substring(colonx + 1);
            String namespaceId = prefixedName.substring(0, colonx);
            namespace = namespaceId.equals("framework") ? this.getSpecificationSource().getFrameworkNamespace() : this.getSpecificationSource().getApplicationNamespace().getChildNamespace(namespaceId);
        } else {
            this._simpleName = prefixedName;
            namespace = this.getSpecificationSource().getApplicationNamespace();
        }
        this.setNamespace(namespace);
        if (namespace.containsPage(this._simpleName)) {
            this.setSpecification(namespace.getPageSpecification(this._simpleName));
            return;
        }
        this.searchForPage(cycle);
        if (this.getSpecification() == null) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"Namespace.no-such-page", (Object)this._simpleName, (Object)namespace.getNamespaceId()));
        }
    }

    public String getSimplePageName() {
        return this._simpleName;
    }

    private void searchForPage(IRequestCycle cycle) {
        INamespace namespace = this.getNamespace();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolving unknown page '" + this._simpleName + "' in " + namespace));
        }
        String expectedName = String.valueOf(this._simpleName) + ".page";
        IResourceLocation namespaceLocation = namespace.getSpecificationLocation();
        if (this.found(namespaceLocation.getRelativeLocation(expectedName))) {
            return;
        }
        if (namespace.isApplicationNamespace()) {
            if (this.found(this.getWebInfAppLocation().getRelativeLocation(expectedName))) {
                return;
            }
            if (this.found(this.getWebInfLocation().getRelativeLocation(expectedName))) {
                return;
            }
            if (this.found(this.getApplicationRootLocation().getRelativeLocation(expectedName))) {
                return;
            }
            String templateName = String.valueOf(this._simpleName) + "." + this.getTemplateExtension();
            IResourceLocation templateLocation = this.getApplicationRootLocation().getRelativeLocation(templateName);
            if (templateLocation.getResourceURL() != null) {
                this.setupImplicitPage(templateLocation);
                return;
            }
            INamespace framework = this.getSpecificationSource().getFrameworkNamespace();
            if (framework.containsPage(this._simpleName)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found " + this._simpleName + " in framework namespace."));
                }
                this.setNamespace(framework);
                this.setSpecification(framework.getPageSpecification(this._simpleName));
                return;
            }
        }
        IComponentSpecification specification = this.getDelegate().findPageSpecification(cycle, namespace, this._simpleName);
        this.setSpecification(specification);
    }

    private void setupImplicitPage(IResourceLocation location) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found HTML template at " + location));
        }
        ComponentSpecification specification = new ComponentSpecification();
        specification.setPageSpecification(true);
        specification.setSpecificationLocation(location);
        this.setSpecification((IComponentSpecification)specification);
        this.install();
    }

    private boolean found(IResourceLocation location) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking: " + location));
        }
        if (location.getResourceURL() == null) {
            return false;
        }
        this.setSpecification(this.getSpecificationSource().getPageSpecification(location));
        this.install();
        return true;
    }

    private void install() {
        INamespace namespace = this.getNamespace();
        IComponentSpecification specification = this.getSpecification();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Installing page " + this._simpleName + " into " + namespace + " as " + specification));
        }
        namespace.installPageSpecification(this._simpleName, specification);
    }

    private String getTemplateExtension() {
        String extension = this.getNamespace().getSpecification().getProperty("org.apache.tapestry.template-extension");
        if (extension == null) {
            extension = "html";
        }
        return extension;
    }

    protected void reset() {
        this._simpleName = null;
        super.reset();
    }
}

