/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.tapestry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.asset.ContextAsset;
import org.apache.tapestry.asset.ExternalAsset;
import org.apache.tapestry.asset.PrivateAsset;
import org.apache.tapestry.binding.ExpressionBinding;
import org.apache.tapestry.binding.FieldBinding;
import org.apache.tapestry.binding.ListenerBinding;
import org.apache.tapestry.binding.StaticBinding;
import org.apache.tapestry.binding.StringBinding;
import org.apache.tapestry.engine.IComponentClassEnhancer;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.engine.ITemplateSource;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.pageload.ComponentTreeWalker;
import org.apache.tapestry.pageload.EstablishDefaultParameterValuesVisitor;
import org.apache.tapestry.pageload.IComponentVisitor;
import org.apache.tapestry.pageload.PageLoader;
import org.apache.tapestry.pageload.PropertyInitializer;
import org.apache.tapestry.pageload.VerifyRequiredParametersVisitor;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.resolver.ComponentSpecificationResolver;
import org.apache.tapestry.resource.ClasspathResourceLocation;
import org.apache.tapestry.resource.ContextResourceLocation;
import org.apache.tapestry.spec.AssetType;
import org.apache.tapestry.spec.BindingType;
import org.apache.tapestry.spec.IAssetSpecification;
import org.apache.tapestry.spec.IBindingSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IContainedComponent;
import org.apache.tapestry.spec.IListenerBindingSpecification;
import org.apache.tapestry.spec.IPropertySpecification;

public abstract class CopyOfPageLoader
extends PageLoader {
    private static final Log LOG;
    private IEngine _engine;
    private IResourceResolver _resolver;
    private IComponentClassEnhancer _enhancer;
    private ComponentSpecificationResolver _componentResolver;
    private List _inheritedBindingQueue = new ArrayList();
    private List _propertyInitializers = new ArrayList();
    private ComponentTreeWalker _establishDefaultParameterValuesWalker;
    private ComponentTreeWalker _verifyRequiredParametersWalker;
    private Locale _locale;
    private int _count;
    private int _depth;
    private int _maxDepth;
    private IResourceLocation _servletLocation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.tapestry.pageload.PageLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    private IPage instantiatePage(String name, INamespace namespace, IComponentSpecification spec) {
        IPage result = null;
        String pageName = namespace.constructQualifiedName(name);
        String className = spec.getComponentClassName();
        ILocation location = spec.getLocation();
        if (Tapestry.isBlank((String)className)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Page " + namespace.constructQualifiedName(name) + " does not specify a component class."));
            }
            if ((className = this._engine.getPropertySource().getPropertyValue("org.apache.tapestry.default-page-class")) == null) {
                className = this.getDefaultPage();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Defaulting to class " + className));
            }
        }
        Class pageClass = this._enhancer.getEnhancedClass(spec, className);
        String enhancedClassName = pageClass.getName();
        try {
            result = this.getPageComponent(pageClass);
            LOG.info((Object)("pageName : " + pageName));
            LOG.info((Object)("className : " + className));
            result.setNamespace(namespace);
            result.setSpecification(spec);
            result.setPageName(pageName);
            result.setPage(result);
            result.setLocale(this._locale);
            result.setLocation(location);
        }
        catch (ClassCastException ex) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.class-not-page", (Object)enhancedClassName), location, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.unable-to-instantiate", (Object)enhancedClassName), location, (Throwable)ex);
        }
        return result;
    }

    public abstract String getDefaultPage();

    public abstract IPage getPageComponent(Class var1) throws Exception;

    public CopyOfPageLoader(IRequestCycle cycle) {
        super(cycle);
        IEngine engine = cycle.getEngine();
        this._resolver = engine.getResourceResolver();
        this._enhancer = engine.getComponentClassEnhancer();
        this._componentResolver = new ComponentSpecificationResolver(cycle);
        RequestContext context = cycle.getRequestContext();
        HttpServletRequest request = context.getRequest();
        String servletPath = request.getServletPath();
        this._servletLocation = new ContextResourceLocation(context.getServlet().getServletContext(), servletPath);
        VerifyRequiredParametersVisitor verifyRequiredParametersVisitor = new VerifyRequiredParametersVisitor();
        this._verifyRequiredParametersWalker = new ComponentTreeWalker(new IComponentVisitor[]{verifyRequiredParametersVisitor});
        EstablishDefaultParameterValuesVisitor establishDefaultParameterValuesVisitor = new EstablishDefaultParameterValuesVisitor(this._resolver);
        this._establishDefaultParameterValuesWalker = new ComponentTreeWalker(new IComponentVisitor[]{establishDefaultParameterValuesVisitor});
    }

    private void bind(IComponent container, IComponent component, IContainedComponent contained) {
        boolean containerFormalOnly;
        IComponentSpecification spec = component.getSpecification();
        boolean formalOnly = !spec.getAllowInformalParameters();
        IComponentSpecification containerSpec = container.getSpecification();
        boolean bl = containerFormalOnly = !containerSpec.getAllowInformalParameters();
        if (contained.getInheritInformalParameters()) {
            if (formalOnly) {
                throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.inherit-informal-invalid-component-formal-only", (Object)component.getExtendedId()), (Object)component, contained.getLocation(), null);
            }
            if (containerFormalOnly) {
                throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.inherit-informal-invalid-container-formal-only", (Object)container.getExtendedId(), (Object)component.getExtendedId()), (Object)component, contained.getLocation(), null);
            }
            QueuedInheritInformalBindings queued = new QueuedInheritInformalBindings(component);
            this._inheritedBindingQueue.add(queued);
        }
        Iterator i = contained.getBindingNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            boolean isFormal = spec.getParameter(name) != null;
            IBindingSpecification bspec = contained.getBinding(name);
            if (formalOnly && !isFormal) {
                throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.formal-parameters-only", (Object)component.getExtendedId(), (Object)name), (Object)component, bspec.getLocation(), null);
            }
            if (!isFormal && spec.isReservedParameterName(name)) continue;
            BindingType type = bspec.getType();
            if (type == BindingType.INHERITED) {
                QueuedInheritedBinding queued = new QueuedInheritedBinding(component, bspec.getValue(), name);
                this._inheritedBindingQueue.add(queued);
                continue;
            }
            if (type == BindingType.LISTENER) {
                this.constructListenerBinding(component, name, (IListenerBindingSpecification)bspec);
                continue;
            }
            IBinding binding = this.convert(container, bspec);
            if (binding == null) continue;
            component.setBinding(name, binding);
        }
    }

    private IBinding convert(IComponent container, IBindingSpecification spec) {
        BindingType type = spec.getType();
        ILocation location = spec.getLocation();
        String value = spec.getValue();
        if (type == BindingType.DYNAMIC) {
            return new ExpressionBinding(this._resolver, container, value, location);
        }
        if (type == BindingType.STRING) {
            return new StringBinding(container, value, location);
        }
        if (type == BindingType.STATIC) {
            return new StaticBinding(value, location);
        }
        if (type == BindingType.FIELD) {
            return new FieldBinding(this._resolver, value, location);
        }
        throw new ApplicationRuntimeException("Unexpected type: " + type + ".");
    }

    private void constructListenerBinding(IComponent component, String bindingName, IListenerBindingSpecification spec) {
        String language = spec.getLanguage();
        if (Tapestry.isBlank((String)language)) {
            language = this._engine.getPropertySource().getPropertyValue("org.apache.tapestry.default-script-language");
        }
        ListenerBinding binding = new ListenerBinding(component.getContainer(), language, spec.getScript(), spec.getLocation());
        component.setBinding(bindingName, (IBinding)binding);
    }

    private void constructComponent(IRequestCycle cycle, IPage page, IComponent container, IComponentSpecification containerSpec, INamespace namespace) {
        ++this._depth;
        if (this._depth > this._maxDepth) {
            this._maxDepth = this._depth;
        }
        ArrayList ids = new ArrayList(containerSpec.getComponentIds());
        int count = ids.size();
        try {
            int i = 0;
            while (i < count) {
                String id = (String)ids.get(i);
                IContainedComponent contained = containerSpec.getComponent(id);
                String type = contained.getType();
                ILocation location = contained.getLocation();
                this._componentResolver.resolve(cycle, namespace, type, location);
                IComponentSpecification componentSpecification = this._componentResolver.getSpecification();
                INamespace componentNamespace = this._componentResolver.getNamespace();
                IComponent component = this.instantiateComponent(page, container, id, componentSpecification, componentNamespace, location);
                container.addComponent(component);
                this.bind(container, component, contained);
                this.constructComponent(cycle, page, component, componentSpecification, componentNamespace);
                ++i;
            }
            this.addAssets(container, containerSpec);
            container.finishLoad(cycle, (IPageLoader)this, containerSpec);
            this.createPropertyInitializers(page, container, containerSpec);
        }
        catch (ApplicationRuntimeException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.unable-to-instantiate-component", (Object)container.getExtendedId(), (Object)ex.getMessage()), (Object)container, null, (Throwable)ex);
        }
        --this._depth;
    }

    public IComponent createImplicitComponent(IRequestCycle cycle, IComponent container, String componentId, String componentType, ILocation location) {
        IPage page = container.getPage();
        this._componentResolver.resolve(cycle, container.getNamespace(), componentType, location);
        INamespace componentNamespace = this._componentResolver.getNamespace();
        IComponentSpecification spec = this._componentResolver.getSpecification();
        IComponent result = this.instantiateComponent(page, container, componentId, spec, componentNamespace, location);
        container.addComponent(result);
        this.constructComponent(cycle, page, result, spec, componentNamespace);
        return result;
    }

    private IComponent instantiateComponent(IPage page, IComponent container, String id, IComponentSpecification spec, INamespace namespace, ILocation location) {
        IComponent result = null;
        String className = spec.getComponentClassName();
        if (Tapestry.isBlank((String)className)) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.tapestry.BaseComponent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            className = clazz.getName();
        }
        Class componentClass = this._enhancer.getEnhancedClass(spec, className);
        String enhancedClassName = componentClass.getName();
        try {
            result = (IComponent)componentClass.newInstance();
        }
        catch (ClassCastException ex) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.class-not-component", (Object)enhancedClassName), (Object)container, spec.getLocation(), (Throwable)ex);
        }
        catch (Throwable ex) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.unable-to-instantiate", (Object)enhancedClassName), (Object)container, spec.getLocation(), ex);
        }
        if (result instanceof IPage) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.page-not-allowed", (Object)result.getExtendedId()), (Object)result, null, null);
        }
        result.setNamespace(namespace);
        result.setSpecification(spec);
        result.setPage(page);
        result.setContainer(container);
        result.setId(id);
        result.setLocation(location);
        ++this._count;
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPage loadPage(String name, INamespace namespace, IRequestCycle cycle, IComponentSpecification specification) {
        IPage page = null;
        this._engine = cycle.getEngine();
        this._locale = this._engine.getLocale();
        this._count = 0;
        this._depth = 0;
        this._maxDepth = 0;
        try {
            page = this.instantiatePage(name, namespace, specification);
            page.attach(this._engine);
            this.constructComponent(cycle, page, (IComponent)page, specification, namespace);
            this._establishDefaultParameterValuesWalker.walkComponentTree((IComponent)page);
            this.establishInheritedBindings();
            this._verifyRequiredParametersWalker.walkComponentTree((IComponent)page);
            this.establishDefaultPropertyValues();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this._locale = null;
            this._engine = null;
            this._inheritedBindingQueue.clear();
            this._propertyInitializers.clear();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this._locale = null;
            this._engine = null;
            this._inheritedBindingQueue.clear();
            this._propertyInitializers.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded page " + page + " with " + this._count + " components (maximum depth " + this._maxDepth + ")"));
        }
        return page;
    }

    private void establishInheritedBindings() {
        LOG.debug((Object)"Establishing inherited bindings");
        int count = this._inheritedBindingQueue.size();
        int i = 0;
        while (i < count) {
            IQueuedInheritedBinding queued = (IQueuedInheritedBinding)this._inheritedBindingQueue.get(i);
            queued.connect();
            ++i;
        }
    }

    private void establishDefaultPropertyValues() {
        LOG.debug((Object)"Setting default property values");
        int count = this._propertyInitializers.size();
        int i = 0;
        while (i < count) {
            PageDetachListener initializer = (PageDetachListener)this._propertyInitializers.get(i);
            initializer.pageDetached(null);
            ++i;
        }
    }

    private void addAssets(IComponent component, IComponentSpecification specification) {
        List names = specification.getAssetNames();
        if (names.isEmpty()) {
            return;
        }
        IResourceLocation specLocation = specification.getSpecificationLocation();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            IAssetSpecification assetSpec = specification.getAsset(name);
            IAsset asset = this.convert(name, component, assetSpec, specLocation);
            component.addAsset(name, asset);
        }
    }

    private void createPropertyInitializers(IPage page, IComponent component, IComponentSpecification spec) {
        List names = spec.getPropertySpecificationNames();
        int count = names.size();
        int i = 0;
        while (i < count) {
            String name = (String)names.get(i);
            IPropertySpecification ps = spec.getPropertySpecification(name);
            String expression = ps.getInitialValue();
            PropertyInitializer initializer = new PropertyInitializer(this._resolver, component, name, expression, ps.getLocation());
            this._propertyInitializers.add(initializer);
            page.addPageDetachListener((PageDetachListener)initializer);
            ++i;
        }
    }

    private IAsset convert(String assetName, IComponent component, IAssetSpecification spec, IResourceLocation specificationLocation) {
        AssetType type = spec.getType();
        String path = spec.getPath();
        ILocation location = spec.getLocation();
        if (type == AssetType.EXTERNAL) {
            return new ExternalAsset(path, location);
        }
        if (type == AssetType.PRIVATE) {
            IResourceLocation baseLocation = specificationLocation;
            if (path.startsWith("/")) {
                baseLocation = new ClasspathResourceLocation(this._resolver, "/");
                path = path.substring(1);
            }
            return new PrivateAsset((ClasspathResourceLocation)this.findAsset(assetName, component, baseLocation, path, location), location);
        }
        return new ContextAsset((ContextResourceLocation)this.findAsset(assetName, component, this._servletLocation, path, location), location);
    }

    private IResourceLocation findAsset(String assetName, IComponent component, IResourceLocation baseLocation, String path, ILocation location) {
        IResourceLocation assetLocation = baseLocation.getRelativeLocation(path);
        IResourceLocation localizedLocation = assetLocation.getLocalization(this._locale);
        if (localizedLocation == null) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"PageLoader.missing-asset", (Object)assetName, (Object)component.getExtendedId(), (Object)assetLocation), (Object)component, location, null);
        }
        return localizedLocation;
    }

    public IEngine getEngine() {
        return this._engine;
    }

    public ITemplateSource getTemplateSource() {
        return this._engine.getTemplateSource();
    }

    private static interface IQueuedInheritedBinding {
        public void connect();
    }

    private static class QueuedInheritedBinding
    implements IQueuedInheritedBinding {
        private IComponent _component;
        private String _containerParameterName;
        private String _parameterName;

        QueuedInheritedBinding(IComponent component, String containerParameterName, String parameterName) {
            this._component = component;
            this._containerParameterName = containerParameterName;
            this._parameterName = parameterName;
        }

        public void connect() {
            IBinding binding = this._component.getContainer().getBinding(this._containerParameterName);
            if (binding == null) {
                return;
            }
            this._component.setBinding(this._parameterName, binding);
        }
    }

    private static class QueuedInheritInformalBindings
    implements IQueuedInheritedBinding {
        private IComponent _component;

        QueuedInheritInformalBindings(IComponent component) {
            this._component = component;
        }

        public void connect() {
            IComponent container = this._component.getContainer();
            Iterator it = container.getBindingNames().iterator();
            while (it.hasNext()) {
                String bindingName = (String)it.next();
                this.connectInformalBinding(container, this._component, bindingName);
            }
        }

        private void connectInformalBinding(IComponent container, IComponent component, String bindingName) {
            IComponentSpecification componentSpec = component.getSpecification();
            IComponentSpecification containerSpec = container.getSpecification();
            if (component.getBinding(bindingName) != null) {
                return;
            }
            if (componentSpec.getParameter(bindingName) != null || componentSpec.isReservedParameterName(bindingName)) {
                return;
            }
            if (containerSpec.getParameter(bindingName) != null || containerSpec.isReservedParameterName(bindingName)) {
                return;
            }
            IBinding binding = container.getBinding(bindingName);
            component.setBinding(bindingName, binding);
        }
    }
}

