/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.html;

import java.util.Date;
import java.util.Iterator;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;

public abstract class Shell
extends AbstractComponent {
    private static final String generatorContent = "Tapestry Application Framework, version " + Tapestry.VERSION;

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        long startTime = 0L;
        boolean rewinding = cycle.isRewinding();
        if (!rewinding) {
            Iterator i;
            IAsset stylesheet;
            startTime = System.currentTimeMillis();
            this.writeDocType(writer, cycle);
            IPage page = this.getPage();
            writer.comment("Application: " + page.getEngine().getSpecification().getName());
            writer.comment("Page: " + page.getPageName());
            writer.comment("Generated: " + new Date());
            writer.begin("html");
            writer.println();
            writer.begin("head");
            writer.println();
            writer.beginEmpty("meta");
            writer.attribute("name", "generator");
            writer.attribute("content", generatorContent);
            writer.println();
            if (this.getRenderContentType()) {
                writer.beginEmpty("meta");
                writer.attribute("http-equiv", "Content-Type");
                writer.attribute("content", writer.getContentType());
                writer.println();
            }
            writer.begin("title");
            writer.print(this.getTitle());
            writer.end();
            writer.println();
            IRender delegate = this.getDelegate();
            if (delegate != null) {
                delegate.render(writer, cycle);
            }
            if ((stylesheet = this.getStylesheet()) != null) {
                this.writeStylesheetLink(writer, cycle, stylesheet);
            }
            if ((i = Tapestry.coerceToIterator(this.getStylesheets())) != null) {
                while (i.hasNext()) {
                    stylesheet = (IAsset)i.next();
                    this.writeStylesheetLink(writer, cycle, stylesheet);
                }
            }
            this.writeRefresh(writer, cycle);
            writer.end();
        }
        this.renderBody(writer, cycle);
        if (!rewinding) {
            writer.end();
            writer.println();
            long endTime = System.currentTimeMillis();
            writer.comment("Render time: ~ " + (endTime - startTime) + " ms");
        }
    }

    private void writeDocType(IMarkupWriter writer, IRequestCycle cycle) {
        String DTD = this.getDTD();
        if (Tapestry.isNonBlank(DTD)) {
            writer.printRaw("<!DOCTYPE HTML PUBLIC \"" + DTD + "\">");
            writer.println();
            return;
        }
        String doctype = this.getDoctype();
        if (Tapestry.isNonBlank(doctype)) {
            writer.printRaw("<!DOCTYPE " + doctype + ">");
            writer.println();
        }
    }

    private void writeStylesheetLink(IMarkupWriter writer, IRequestCycle cycle, IAsset stylesheet) {
        writer.beginEmpty("link");
        writer.attribute("rel", "stylesheet");
        writer.attribute("type", "text/css");
        writer.attribute("href", stylesheet.buildURL(cycle));
        writer.println();
    }

    private void writeRefresh(IMarkupWriter writer, IRequestCycle cycle) {
        int refresh = this.getRefresh();
        if (refresh <= 0) {
            return;
        }
        IEngineService pageService = cycle.getEngine().getService("page");
        String pageName = this.getPage().getPageName();
        ILink link = pageService.getLink(cycle, null, new String[]{pageName});
        StringBuffer buffer = new StringBuffer();
        buffer.append(refresh);
        buffer.append("; URL=");
        buffer.append(link.getAbsoluteURL());
        writer.beginEmpty("meta");
        writer.attribute("http-equiv", "Refresh");
        writer.attribute("content", buffer.toString());
    }

    public abstract IRender getDelegate();

    public abstract int getRefresh();

    public abstract IAsset getStylesheet();

    public abstract String getTitle();

    public abstract String getDoctype();

    public abstract String getDTD();

    public abstract Object getStylesheets();

    public abstract boolean getRenderContentType();
}

