/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.util.ResourceBundle;
import org.apache.commons.lang.enum.Enum;
import org.apache.tapestry.form.IPropertySelectionModel;

public class EnumPropertySelectionModel
implements IPropertySelectionModel {
    private Enum[] _options;
    private String[] _labels;
    private String _resourcePrefix;
    private ResourceBundle _bundle;

    public EnumPropertySelectionModel(Enum[] options, ResourceBundle bundle, String resourcePrefix) {
        this._options = options;
        this._bundle = bundle;
        this._resourcePrefix = resourcePrefix;
    }

    public EnumPropertySelectionModel(Enum[] options, ResourceBundle bundle) {
        this(options, bundle, null);
    }

    public int getOptionCount() {
        return this._options.length;
    }

    public Object getOption(int index) {
        return this._options[index];
    }

    public String getLabel(int index) {
        if (this._labels == null) {
            this.readLabels();
        }
        return this._labels[index];
    }

    public String getValue(int index) {
        return Integer.toString(index);
    }

    public Object translateValue(String value) {
        int index = Integer.parseInt(value);
        return this._options[index];
    }

    private void readLabels() {
        this._labels = new String[this._options.length];
        int i = 0;
        while (i < this._options.length) {
            String enumerationId = this._options[i].getName();
            String key = this._resourcePrefix == null ? enumerationId : this._resourcePrefix + "." + enumerationId;
            this._labels[i] = this._bundle.getString(key);
            ++i;
        }
    }
}

