/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IPropertySource;
import org.apache.tapestry.engine.ITemplateSource;
import org.apache.tapestry.engine.ITemplateSourceDelegate;
import org.apache.tapestry.engine.NullTemplateSourceDelegate;
import org.apache.tapestry.parse.ComponentTemplate;
import org.apache.tapestry.parse.ITemplateParserDelegate;
import org.apache.tapestry.parse.TemplateParseException;
import org.apache.tapestry.parse.TemplateParser;
import org.apache.tapestry.parse.TemplateToken;
import org.apache.tapestry.resolver.ComponentSpecificationResolver;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.util.DelegatingPropertySource;
import org.apache.tapestry.util.IRenderDescription;
import org.apache.tapestry.util.LocalizedPropertySource;
import org.apache.tapestry.util.MultiKey;
import org.apache.tapestry.util.PropertyHolderPropertySource;

public class DefaultTemplateSource
implements ITemplateSource,
IRenderDescription {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$engine$DefaultTemplateSource == null ? (class$org$apache$tapestry$engine$DefaultTemplateSource = DefaultTemplateSource.class$("org.apache.tapestry.engine.DefaultTemplateSource")) : class$org$apache$tapestry$engine$DefaultTemplateSource));
    private static final String TEMPLATE_ENCODING_PROPERTY_NAME = "org.apache.tapestry.template-encoding";
    private Map _cache = Collections.synchronizedMap(new HashMap());
    private Map _templates = Collections.synchronizedMap(new HashMap());
    private int _tokenCount;
    private static final int BUFFER_SIZE = 2000;
    private TemplateParser _parser;
    private IResourceLocation _applicationRootLocation;
    private ITemplateSourceDelegate _delegate;
    static /* synthetic */ Class class$org$apache$tapestry$engine$DefaultTemplateSource;
    static /* synthetic */ Class class$org$apache$tapestry$engine$ITemplateSourceDelegate;

    public void reset() {
        this._cache.clear();
        this._templates.clear();
        this._tokenCount = 0;
    }

    public ComponentTemplate getTemplate(IRequestCycle cycle, IComponent component) {
        Locale locale;
        IComponentSpecification specification = component.getSpecification();
        IResourceLocation specificationLocation = specification.getSpecificationLocation();
        MultiKey key = new MultiKey(new Object[]{specificationLocation, locale = component.getPage().getLocale()}, false);
        ComponentTemplate result = this.searchCache(key);
        if (result != null) {
            return result;
        }
        result = this.findTemplate(cycle, specificationLocation, component, locale);
        if (result == null) {
            result = this.getTemplateFromDelegate(cycle, component, locale);
            if (result != null) {
                return result;
            }
            String stringKey = component.getSpecification().isPageSpecification() ? "DefaultTemplateSource.no-template-for-page" : "DefaultTemplateSource.no-template-for-component";
            throw new ApplicationRuntimeException(Tapestry.format(stringKey, component.getExtendedId(), locale), component, component.getLocation(), null);
        }
        this.saveToCache(key, result);
        return result;
    }

    private ComponentTemplate searchCache(Object key) {
        return (ComponentTemplate)this._cache.get(key);
    }

    private void saveToCache(Object key, ComponentTemplate template) {
        this._cache.put(key, template);
    }

    private ComponentTemplate getTemplateFromDelegate(IRequestCycle cycle, IComponent component, Locale locale) {
        if (this._delegate == null) {
            IEngine engine = cycle.getEngine();
            IApplicationSpecification spec = engine.getSpecification();
            this._delegate = spec.checkExtension("org.apache.tapestry.template-source-delegate") ? (ITemplateSourceDelegate)spec.getExtension("org.apache.tapestry.template-source-delegate", class$org$apache$tapestry$engine$ITemplateSourceDelegate == null ? (class$org$apache$tapestry$engine$ITemplateSourceDelegate = DefaultTemplateSource.class$("org.apache.tapestry.engine.ITemplateSourceDelegate")) : class$org$apache$tapestry$engine$ITemplateSourceDelegate) : NullTemplateSourceDelegate.getSharedInstance();
        }
        return this._delegate.findTemplate(cycle, component, locale);
    }

    private ComponentTemplate findTemplate(IRequestCycle cycle, IResourceLocation location, IComponent component, Locale locale) {
        int dotx;
        IAsset templateAsset = component.getAsset("$template");
        if (templateAsset != null) {
            return this.readTemplateFromAsset(cycle, component, templateAsset);
        }
        String name = location.getName();
        String templateBaseName = name.substring(0, (dotx = name.lastIndexOf(46)) + 1) + this.getTemplateExtension(component);
        ComponentTemplate result = this.findStandardTemplate(cycle, location, component, templateBaseName, locale);
        if (result == null && component.getSpecification().isPageSpecification() && component.getNamespace().isApplicationNamespace()) {
            result = this.findPageTemplateInApplicationRoot(cycle, component, templateBaseName, locale);
        }
        return result;
    }

    private ComponentTemplate findPageTemplateInApplicationRoot(IRequestCycle cycle, IComponent component, String templateBaseName, Locale locale) {
        IResourceLocation baseLocation;
        IResourceLocation localizedLocation;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking for " + templateBaseName + " in application root"));
        }
        if (this._applicationRootLocation == null) {
            this._applicationRootLocation = Tapestry.getApplicationRootLocation(cycle);
        }
        if ((localizedLocation = (baseLocation = this._applicationRootLocation.getRelativeLocation(templateBaseName)).getLocalization(locale)) == null) {
            return null;
        }
        return this.getOrParseTemplate(cycle, localizedLocation, component);
    }

    private ComponentTemplate readTemplateFromAsset(IRequestCycle cycle, IComponent component, IAsset asset) {
        InputStream stream = asset.getResourceAsStream(cycle);
        char[] templateData = null;
        try {
            String encoding = this.getTemplateEncoding(cycle, component, null);
            templateData = this.readTemplateStream(stream, encoding);
            stream.close();
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("DefaultTemplateSource.unable-to-read-template", asset), ex);
        }
        IResourceLocation resourceLocation = asset.getResourceLocation();
        return this.constructTemplateInstance(cycle, templateData, resourceLocation, component);
    }

    private ComponentTemplate findStandardTemplate(IRequestCycle cycle, IResourceLocation location, IComponent component, String templateBaseName, Locale locale) {
        IResourceLocation baseTemplateLocation;
        IResourceLocation localizedTemplateLocation;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for localized version of template for " + location + " in locale " + locale.getDisplayName()));
        }
        if ((localizedTemplateLocation = (baseTemplateLocation = location.getRelativeLocation(templateBaseName)).getLocalization(locale)) == null) {
            return null;
        }
        return this.getOrParseTemplate(cycle, localizedTemplateLocation, component);
    }

    private ComponentTemplate getOrParseTemplate(IRequestCycle cycle, IResourceLocation location, IComponent component) {
        ComponentTemplate result = (ComponentTemplate)this._templates.get(location);
        if (result != null) {
            return result;
        }
        result = this.parseTemplate(cycle, location, component);
        if (result != null) {
            this._templates.put(location, result);
        }
        return result;
    }

    private ComponentTemplate parseTemplate(IRequestCycle cycle, IResourceLocation location, IComponent component) {
        String encoding = this.getTemplateEncoding(cycle, component, location.getLocale());
        char[] templateData = this.readTemplate(location, encoding);
        if (templateData == null) {
            return null;
        }
        return this.constructTemplateInstance(cycle, templateData, location, component);
    }

    private synchronized ComponentTemplate constructTemplateInstance(IRequestCycle cycle, char[] templateData, IResourceLocation location, IComponent component) {
        TemplateToken[] tokens;
        if (this._parser == null) {
            this._parser = new TemplateParser();
        }
        ParserDelegate delegate = new ParserDelegate(component, cycle);
        try {
            tokens = this._parser.parse(templateData, delegate, location);
        }
        catch (TemplateParseException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("DefaultTemplateSource.unable-to-parse-template", location), ex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsed " + tokens.length + " tokens from template"));
        }
        this._tokenCount += tokens.length;
        return new ComponentTemplate(templateData, tokens);
    }

    private char[] readTemplate(IResourceLocation location, String encoding) {
        char[] cArray;
        URL url;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reading template " + location));
        }
        if ((url = location.getResourceURL()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Template does not exist.");
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reading template from URL " + url));
        }
        InputStream stream = null;
        try {
            stream = url.openStream();
            cArray = this.readTemplateStream(stream, encoding);
            Object var7_7 = null;
        }
        catch (IOException ex) {
            try {
                throw new ApplicationRuntimeException(Tapestry.format("DefaultTemplateSource.unable-to-read-template", location), ex);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                Tapestry.close(stream);
                throw throwable;
            }
        }
        Tapestry.close(stream);
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] readTemplateStream(InputStream stream, String encoding) throws IOException {
        char[] charBuffer = new char[2000];
        StringBuffer buffer = new StringBuffer();
        InputStreamReader reader = encoding != null ? new InputStreamReader((InputStream)new BufferedInputStream(stream), encoding) : new InputStreamReader(new BufferedInputStream(stream));
        try {
            int charsRead;
            while ((charsRead = reader.read(charBuffer, 0, 2000)) > 0) {
                buffer.append(charBuffer, 0, charsRead);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        int length = buffer.length();
        charBuffer = new char[length];
        buffer.getChars(0, length, charBuffer, 0);
        return charBuffer;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("tokenCount", this._tokenCount);
        builder.append("templates", this._templates.keySet());
        return builder.toString();
    }

    private String getTemplateExtension(IComponent component) {
        String extension = component.getSpecification().getProperty("org.apache.tapestry.template-extension");
        if (extension != null) {
            return extension;
        }
        extension = component.getNamespace().getSpecification().getProperty("org.apache.tapestry.template-extension");
        if (extension != null) {
            return extension;
        }
        return "html";
    }

    public synchronized void renderDescription(IMarkupWriter writer) {
        writer.print("DefaultTemplateSource[");
        if (this._tokenCount > 0) {
            writer.print(this._tokenCount);
            writer.print(" tokens");
        }
        if (this._cache != null) {
            boolean first = true;
            Iterator i = this._cache.entrySet().iterator();
            while (i.hasNext()) {
                if (first) {
                    writer.begin("ul");
                    first = false;
                }
                Map.Entry e = i.next();
                Object key = e.getKey();
                ComponentTemplate template = (ComponentTemplate)e.getValue();
                writer.begin("li");
                writer.print(key.toString());
                writer.print(" (");
                writer.print(template.getTokenCount());
                writer.print(" tokens)");
                writer.println();
                writer.end();
            }
            if (!first) {
                writer.end();
                writer.beginEmpty("br");
            }
        }
        writer.print("]");
    }

    private String getTemplateEncoding(IRequestCycle cycle, IComponent component, Locale locale) {
        IPropertySource source = this.getComponentPropertySource(cycle, component);
        if (locale != null) {
            source = new LocalizedPropertySource(locale, source);
        }
        return this.getTemplateEncodingProperty(source);
    }

    private IPropertySource getComponentPropertySource(IRequestCycle cycle, IComponent component) {
        DelegatingPropertySource source = new DelegatingPropertySource();
        source.addSource(new PropertyHolderPropertySource(component.getSpecification()));
        source.addSource(new PropertyHolderPropertySource(component.getNamespace().getSpecification()));
        source.addSource(cycle.getEngine().getPropertySource());
        return source;
    }

    private String getTemplateEncodingProperty(IPropertySource source) {
        return source.getPropertyValue(TEMPLATE_ENCODING_PROPERTY_NAME);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ParserDelegate
    implements ITemplateParserDelegate {
        private IComponent _component;
        private ComponentSpecificationResolver _resolver;
        private IRequestCycle _cycle;

        ParserDelegate(IComponent component, IRequestCycle cycle) {
            this._component = component;
            this._resolver = new ComponentSpecificationResolver(cycle);
            this._cycle = cycle;
        }

        public boolean getKnownComponent(String componentId) {
            return this._component.getSpecification().getComponent(componentId) != null;
        }

        public boolean getAllowBody(String componentId, ILocation location) {
            IComponent embedded = this._component.getComponent(componentId);
            if (embedded == null) {
                throw Tapestry.createNoSuchComponentException(this._component, componentId, location);
            }
            return embedded.getSpecification().getAllowBody();
        }

        public boolean getAllowBody(String libraryId, String type, ILocation location) {
            INamespace namespace = this._component.getNamespace();
            this._resolver.resolve(this._cycle, namespace, libraryId, type, location);
            IComponentSpecification spec = this._resolver.getSpecification();
            return spec.getAllowBody();
        }
    }
}

