/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.ISpecificationSource;
import org.apache.tapestry.engine.Namespace;
import org.apache.tapestry.parse.SpecificationParser;
import org.apache.tapestry.resource.ClasspathResourceLocation;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.ILibrarySpecification;
import org.apache.tapestry.spec.LibrarySpecification;
import org.apache.tapestry.util.IRenderDescription;
import org.apache.tapestry.util.pool.Pool;
import org.apache.tapestry.util.xml.DocumentParseException;

public class DefaultSpecificationSource
implements ISpecificationSource,
IRenderDescription {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$engine$DefaultSpecificationSource == null ? (class$org$apache$tapestry$engine$DefaultSpecificationSource = DefaultSpecificationSource.class$("org.apache.tapestry.engine.DefaultSpecificationSource")) : class$org$apache$tapestry$engine$DefaultSpecificationSource));
    private static final String PARSER_POOL_KEY = "org.apache.tapestry.SpecificationParser";
    private IResourceResolver _resolver;
    private IApplicationSpecification _specification;
    private INamespace _applicationNamespace;
    private INamespace _frameworkNamespace;
    private Map _componentCache = new HashMap();
    private Map _pageCache = new HashMap();
    private Map _libraryCache = new HashMap();
    private Map _namespaceCache = new HashMap();
    private Pool _pool;
    static /* synthetic */ Class class$org$apache$tapestry$engine$DefaultSpecificationSource;

    public DefaultSpecificationSource(IResourceResolver resolver, IApplicationSpecification specification, Pool pool) {
        this._resolver = resolver;
        this._specification = specification;
        this._pool = pool;
    }

    public synchronized void reset() {
        this._componentCache.clear();
        this._pageCache.clear();
        this._libraryCache.clear();
        this._namespaceCache.clear();
        this._applicationNamespace = null;
        this._frameworkNamespace = null;
    }

    protected IComponentSpecification parseSpecification(IResourceLocation resourceLocation, boolean asPage) {
        IComponentSpecification result = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing component specification " + resourceLocation));
        }
        SpecificationParser parser = this.getParser();
        try {
            block6: {
                try {
                    if (asPage) {
                        result = parser.parsePageSpecification(resourceLocation);
                        break block6;
                    }
                    result = parser.parseComponentSpecification(resourceLocation);
                }
                catch (DocumentParseException ex) {
                    throw new ApplicationRuntimeException(Tapestry.format("DefaultSpecificationSource.unable-to-parse-specification", resourceLocation), ex);
                }
            }
            Object var7_5 = null;
            this.discardParser(parser);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.discardParser(parser);
            throw throwable;
        }
        return result;
    }

    protected ILibrarySpecification parseLibrarySpecification(IResourceLocation resourceLocation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing library specification " + resourceLocation));
        }
        try {
            return this.getParser().parseLibrarySpecification(resourceLocation);
        }
        catch (DocumentParseException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("DefaultSpecificationSource.unable-to-parse-specification", resourceLocation), ex);
        }
    }

    public synchronized String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("applicationNamespace", (Object)this._applicationNamespace);
        builder.append("frameworkNamespace", (Object)this._frameworkNamespace);
        builder.append("specification", (Object)this._specification);
        return builder.toString();
    }

    public synchronized void renderDescription(IMarkupWriter writer) {
        writer.print("DefaultSpecificationSource[");
        this.writeCacheDescription(writer, "page", this._pageCache);
        writer.beginEmpty("br");
        writer.println();
        this.writeCacheDescription(writer, "component", this._componentCache);
        writer.print("]");
        writer.println();
    }

    private void writeCacheDescription(IMarkupWriter writer, String name, Map cache) {
        Set keySet = cache.keySet();
        writer.print(Tapestry.size(keySet));
        writer.print(" cached ");
        writer.print(name);
        writer.print(" specifications:");
        boolean first = true;
        Iterator i = keySet.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (first) {
                writer.begin("ul");
                first = false;
            }
            writer.begin("li");
            writer.print(key.toString());
            writer.end();
        }
        if (!first) {
            writer.end();
        }
    }

    public synchronized IComponentSpecification getComponentSpecification(IResourceLocation resourceLocation) {
        IComponentSpecification result = (IComponentSpecification)this._componentCache.get(resourceLocation);
        if (result == null) {
            result = this.parseSpecification(resourceLocation, false);
            this._componentCache.put(resourceLocation, result);
        }
        return result;
    }

    public synchronized IComponentSpecification getPageSpecification(IResourceLocation resourceLocation) {
        IComponentSpecification result = (IComponentSpecification)this._pageCache.get(resourceLocation);
        if (result == null) {
            result = this.parseSpecification(resourceLocation, true);
            this._pageCache.put(resourceLocation, result);
        }
        return result;
    }

    public synchronized ILibrarySpecification getLibrarySpecification(IResourceLocation resourceLocation) {
        ILibrarySpecification result = (LibrarySpecification)this._libraryCache.get(resourceLocation);
        if (result == null) {
            result = this.parseLibrarySpecification(resourceLocation);
            this._libraryCache.put(resourceLocation, result);
        }
        return result;
    }

    protected SpecificationParser getParser() {
        SpecificationParser result = (SpecificationParser)this._pool.retrieve(PARSER_POOL_KEY);
        if (result == null) {
            result = new SpecificationParser(this._resolver);
        }
        return result;
    }

    protected void discardParser(SpecificationParser parser) {
        this._pool.store(PARSER_POOL_KEY, parser);
    }

    public synchronized INamespace getApplicationNamespace() {
        if (this._applicationNamespace == null) {
            this._applicationNamespace = new Namespace(null, null, this._specification, this);
        }
        return this._applicationNamespace;
    }

    public synchronized INamespace getFrameworkNamespace() {
        if (this._frameworkNamespace == null) {
            ClasspathResourceLocation frameworkLocation = new ClasspathResourceLocation(this._resolver, "/org/apache/tapestry/Framework.library");
            ILibrarySpecification ls = this.getLibrarySpecification(frameworkLocation);
            this._frameworkNamespace = new Namespace("framework", null, ls, this);
        }
        return this._frameworkNamespace;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

