/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.asset;

import java.io.InputStream;
import java.net.URL;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.asset.AbstractAsset;
import org.apache.tapestry.resource.ContextResourceLocation;

public class ContextAsset
extends AbstractAsset
implements IAsset {
    private String _resolvedURL;

    public ContextAsset(ContextResourceLocation resourceLocation, ILocation location) {
        super(resourceLocation, location);
    }

    public String buildURL(IRequestCycle cycle) {
        if (this._resolvedURL == null) {
            IEngine engine = cycle.getEngine();
            String contextPath = engine.getContextPath();
            this._resolvedURL = contextPath + this.getResourceLocation().getPath();
        }
        return this._resolvedURL;
    }

    public InputStream getResourceAsStream(IRequestCycle cycle) {
        try {
            URL url = this.getResourceLocation().getResourceURL();
            return url.openStream();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("ContextAsset.resource-missing", this.getResourceLocation()), ex);
        }
    }
}

