/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.seasar.framework.exception.ParseRuntimeException;

public final class DateConversionUtil {
    private DateConversionUtil() {
    }

    public static Date toDate(Object o) {
        return DateConversionUtil.toDate(o, null);
    }

    public static Date toDate(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return DateConversionUtil.toDate((String)o, pattern);
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Calendar) {
            return ((Calendar)o).getTime();
        }
        return DateConversionUtil.toDate(o.toString(), pattern);
    }

    public static Date toDate(String s, String pattern) {
        SimpleDateFormat sdf = null;
        sdf = pattern != null ? new SimpleDateFormat(pattern) : new SimpleDateFormat();
        try {
            return sdf.parse(s);
        }
        catch (ParseException ex) {
            throw new ParseRuntimeException(ex);
        }
    }
}

