/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.log;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.seasar.framework.message.MessageFormatter;

public final class Logger {
    private static Map loggerMap_ = new HashMap();
    private Category category_;

    private Logger(Class clazz) {
        this.category_ = Category.getInstance((Class)clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Logger getLogger(Class clazz) {
        Logger logger = (Logger)loggerMap_.get(clazz);
        if (logger == null) {
            Map map = loggerMap_;
            synchronized (map) {
                logger = (Logger)loggerMap_.get(clazz);
                if (logger == null) {
                    logger = new Logger(clazz);
                    loggerMap_.put(clazz, logger);
                }
            }
        }
        return logger;
    }

    public final boolean isDebugEnabled() {
        return this.category_.isDebugEnabled();
    }

    public final void debug(Object message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.category_.debug(message, throwable);
        }
    }

    public final void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.category_.debug(message);
        }
    }

    public final boolean isInfoEnabled() {
        return this.category_.isInfoEnabled();
    }

    public final void info(Object message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.category_.info(message, throwable);
        }
    }

    public final void info(Object message) {
        if (this.isInfoEnabled()) {
            this.category_.info(message);
        }
    }

    public final void warn(Object message, Throwable throwable) {
        this.category_.warn(message, throwable);
    }

    public final void warn(Object message) {
        this.category_.warn(message);
    }

    public final void error(Object message, Throwable throwable) {
        this.category_.error(message, throwable);
    }

    public final void error(Object message) {
        this.category_.error(message);
    }

    public final void fatal(Object message, Throwable throwable) {
        this.category_.fatal(message, throwable);
    }

    public final void fatal(Object message) {
        this.category_.fatal(message);
    }

    public final void log(Priority priority, Object message) {
        this.category_.log(priority, message);
    }

    public final void log(Priority priority, Object message, Throwable throwable) {
        this.category_.log(priority, message, throwable);
    }

    public final void log(Throwable throwable) {
        this.error(throwable.getMessage(), throwable);
    }

    public final void log(String messageCode, Object[] args) {
        this.log(messageCode, args, null);
    }

    public final void log(String messageCode, Object[] args, Throwable throwable) {
        Priority priority = Logger.getPriority(messageCode.charAt(0));
        if (this.category_.isEnabledFor(priority)) {
            String message = MessageFormatter.getSimpleMessage(messageCode, args);
            this.log(priority, message, throwable);
        }
    }

    private static Priority getPriority(char messageType) {
        switch (messageType) {
            case 'D': {
                return Priority.DEBUG;
            }
            case 'I': {
                return Priority.INFO;
            }
            case 'W': {
                return Priority.WARN;
            }
            case 'E': {
                return Priority.ERROR;
            }
            case 'F': {
                return Priority.FATAL;
            }
        }
        throw new IllegalArgumentException(String.valueOf(messageType));
    }
}

