/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.lexer;

import org.codehaus.groovy.syntax.ReadException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.lexer.Delimiter;
import org.codehaus.groovy.syntax.lexer.GroovyExpressionLexer;
import org.codehaus.groovy.syntax.lexer.Lexer;
import org.codehaus.groovy.syntax.lexer.LexerBase;
import org.codehaus.groovy.syntax.lexer.LexerException;

public class GStringLexer
extends LexerBase {
    protected boolean sentStartToken = false;
    protected boolean sentEndToken = false;
    protected StringBuffer fullText = new StringBuffer();
    protected int fullTextStartLine = 0;
    protected int fullTextStartColumn = 0;
    protected GroovyExpressionLexer child = null;
    protected boolean inExpression = false;

    protected Token undelegatedNextToken() throws ReadException, LexerException {
        Token token = null;
        if (!this.sentStartToken) {
            this.mark();
            this.fullTextStartLine = this.getStartLine();
            this.fullTextStartColumn = this.getStartColumn();
            this.sentStartToken = true;
            return this.symbol(901);
        }
        if (this.la(1) == '\uffff') {
            if (!this.sentEndToken) {
                this.sentEndToken = true;
                token = Token.newSymbol(902, this.fullTextStartLine, this.fullTextStartColumn);
                token.setText(this.fullText.toString());
            }
            return token;
        }
        if (this.inExpression && this.la(1) != '}') {
            this.mark();
            this.unexpected(this.la(1), 0);
        }
        this.mark();
        StringBuffer segment = new StringBuffer();
        block10: while (true) {
            char c = this.la(1);
            switch (c) {
                case '\uffff': {
                    break block10;
                }
                case '\n': 
                case '\r': {
                    this.readEOL(segment);
                    continue block10;
                }
                case '\\': {
                    switch (this.la(2)) {
                        case '$': 
                        case '\\': {
                            this.consume();
                            segment.append(this.consume());
                            continue block10;
                        }
                    }
                    segment.append(this.consume());
                    continue block10;
                }
                case '$': {
                    if (this.la(2) == '{') {
                        if (segment.length() != 0) break block10;
                        this.sourceDelimiting(false);
                        this.mark();
                        this.consume();
                        this.consume();
                        token = this.symbol(903);
                        this.inExpression = true;
                        if (this.child == null) {
                            this.child = new GroovyExpressionLexer();
                        } else {
                            this.child.reset();
                        }
                        this.delegate(this.child);
                        break block10;
                    }
                    segment.append(this.consume());
                    continue block10;
                }
                case '}': {
                    if (this.inExpression) {
                        this.mark();
                        this.consume();
                        token = this.symbol(904);
                        this.inExpression = false;
                        break block10;
                    }
                    segment.append(this.consume());
                    continue block10;
                }
                default: {
                    segment.append(this.consume());
                    continue block10;
                }
            }
            break;
        }
        if (token != null) {
            return token;
        }
        return Token.newString(segment.toString(), this.getStartLine(), this.getStartColumn());
    }

    protected void sourceDelimiting(boolean delimit) {
        if (this.source instanceof Delimiter) {
            ((Delimiter)((Object)this.source)).delimit(delimit);
        }
    }

    public void delegate(Lexer to) {
        this.delegate = to;
        this.sourceDelimiting(false);
        to.setSource(this);
    }

    public void undelegate() {
        if (this.delegate != null) {
            this.delegate.unsetSource();
            this.delegate = null;
            this.sourceDelimiting(true);
        }
    }

    public void setSource(Lexer source) {
        super.setSource(source);
        this.sentStartToken = false;
        this.sentEndToken = false;
        this.fullTextStartLine = this.getStartLine();
        this.fullTextStartColumn = this.getStartColumn();
        this.fullText = new StringBuffer();
        this.inExpression = false;
    }

    public void unsetSource() {
        super.unsetSource();
        this.sentStartToken = false;
        this.sentEndToken = false;
        this.fullText = null;
        this.inExpression = false;
    }

    public char consume() throws LexerException, ReadException {
        char c = super.consume();
        if (c != '\uffff') {
            this.fullText.append(c);
        }
        return c;
    }
}

