/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.Set;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ForStatement;

public class VariableScopeCodeVisitor
extends CodeVisitorSupport {
    private VariableScope scope;

    public VariableScopeCodeVisitor(VariableScope scope) {
        this.scope = scope;
    }

    public Set getReferencedVariables() {
        return this.scope.getReferencedVariables();
    }

    public Set getDeclaredVariables() {
        return this.scope.getDeclaredVariables();
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        Expression leftExpression = expression.getLeftExpression();
        if (expression.getOperation().isA(1100) && leftExpression instanceof VariableExpression) {
            this.declareVariable((VariableExpression)leftExpression);
        } else {
            leftExpression.visit(this);
        }
        expression.getRightExpression().visit(this);
    }

    public void visitForLoop(ForStatement forLoop) {
        this.declareVariable(forLoop.getVariable());
        super.visitForLoop(forLoop);
    }

    public void visitClosureExpression(ClosureExpression expression) {
        VariableScopeCodeVisitor visitor = this.createClosureVisitor(expression);
        expression.getCode().visit(visitor);
    }

    public void visitVariableExpression(VariableExpression expression) {
        String variable = expression.getVariable();
        this.getReferencedVariables().add(variable);
    }

    public void visitPostfixExpression(PostfixExpression expression) {
        Expression exp = expression.getExpression();
        if (exp instanceof VariableExpression) {
            this.declareVariable((VariableExpression)exp);
        } else {
            exp.visit(this);
        }
    }

    public void visitPrefixExpression(PrefixExpression expression) {
        Expression exp = expression.getExpression();
        if (exp instanceof VariableExpression) {
            this.declareVariable((VariableExpression)exp);
        } else {
            exp.visit(this);
        }
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        if (call.isImplicitThis()) {
            this.getReferencedVariables().add(call.getMethod());
        }
        super.visitMethodCallExpression(call);
    }

    protected void setParameters(Parameter[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            this.declareVariable(parameters[i].getName());
        }
    }

    protected void declareVariable(VariableExpression varExp) {
        String variable = varExp.getVariable();
        this.declareVariable(variable);
    }

    protected void declareVariable(String variable) {
        this.getDeclaredVariables().add(variable);
        this.getReferencedVariables().add(variable);
    }

    protected VariableScopeCodeVisitor createClosureVisitor(ClosureExpression expression) {
        VariableScope closureScope = new VariableScope(this.scope);
        expression.setVariableScope(closureScope);
        VariableScopeCodeVisitor answer = new VariableScopeCodeVisitor(closureScope);
        answer.setParameters(expression.getParameters());
        return answer;
    }
}

