/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator2;

public class PropertyExpression
extends Expression {
    private Expression objectExpression;
    private String property;
    private boolean safe;
    private boolean isStatic = false;
    private Method getter = null;
    private Method setter = null;
    private Field field = null;
    private int access = -1;

    public boolean isStatic() {
        return this.isStatic;
    }

    public PropertyExpression(Expression objectExpression, String property) {
        this(objectExpression, property, false);
    }

    public PropertyExpression(Expression objectExpression, String property, boolean safe) {
        this.objectExpression = objectExpression;
        this.property = property;
        this.safe = safe;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitPropertyExpression(this);
    }

    public boolean isDynamic() {
        return true;
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return this;
    }

    protected void resolveType(AsmClassGenerator2 resolver) {
        this.objectExpression.resolve(resolver);
        resolver.resolve(this);
    }

    public Expression getObjectExpression() {
        return this.objectExpression;
    }

    public String getProperty() {
        return this.property;
    }

    public String getText() {
        return this.objectExpression.getText() + "." + this.property;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public String toString() {
        return super.toString() + "[object: " + this.objectExpression + " property: " + this.property + "]";
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    public void setGetter(Method meth) {
        Class<?> returntype = meth.getReturnType();
        Class oldType = this.getTypeClass();
        if (oldType == null || oldType == Object.class || oldType == returntype) {
            this.getter = meth;
            this.setTypeClass(returntype);
            this.setTypeResolved(true);
        }
    }

    public Method getGetter() {
        return this.getter;
    }

    public void setSetter(Method method) {
        Class<?> paramType = method.getParameterTypes()[0];
        Class wasType = this.getTypeClass();
        if (wasType == null || wasType == Object.class || wasType == paramType) {
            this.setter = method;
            this.setTypeClass(paramType);
            this.setTypeResolved(true);
        }
    }

    public Method getSetter() {
        return this.setter;
    }

    public void setField(Field fld) {
        this.field = fld;
        this.setStatic(Modifier.isStatic(fld.getModifiers()));
        this.setTypeClass(fld.getType());
    }

    public Field getField() {
        return this.field;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public int getAccess() {
        return this.access;
    }
}

