package org.seasar.flex;

import java.util.List;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import flashgateway.action.ActionContext;
import flashgateway.adapter.java.JavaAdapter;

/**
 * @author higa
 *  
 */
public class S2Adapter extends JavaAdapter {

	/**
	 * @see flashgateway.adapter.ServiceAdapter#invokeFunction(flashgateway.action.ActionContext,
	 *      java.lang.String, java.lang.String, java.util.List)
	 */
	public Object invokeFunction(ActionContext ctx, String name,
			String methodName, List argList) throws Throwable {

		S2Container container = SingletonS2ContainerFactory.getContainer();
		Object component = container.getComponent(name);
		BeanDesc beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
		return beanDesc.invoke(component, methodName, argList.toArray());
	}

	/**
	 * @see flashgateway.adapter.ServiceAdapter#supportsService(flashgateway.action.ActionContext,
	 *      java.lang.String, java.lang.String, java.util.List,
	 *      java.lang.String)
	 */
	public boolean supportsService(ActionContext ctx, String name,
			String methodName, List argList, String arg4) throws Exception {

		S2Container container = SingletonS2ContainerFactory.getContainer();
		return container.hasComponentDef(name);
	}
}