package org.seasar.tapestry;

import ognl.OgnlRuntime;

import org.apache.tapestry.engine.BaseEngine;
import org.apache.tapestry.engine.IPageSource;
import org.apache.tapestry.request.RequestContext;
import org.seasar.tapestry.global.GlobalProxy;
import org.seasar.tapestry.global.GlobalProxyPropertyAccessor;

/**
 * @author higa
 *  
 */
public class S2Engine extends BaseEngine {
	static {
		OgnlRuntime.setPropertyAccessor(GlobalProxy.class,
				new GlobalProxyPropertyAccessor());
	}

	protected Object createGlobal(RequestContext context) {
		Object global = super.createGlobal(context);
		return new GlobalProxy(global);
	}

	protected IPageSource createPageSource(RequestContext context) {
		IPageSource pageSource = new S2PageSource(this);
		return pageSource;
	}
}