/*
 * 쐬F 2004/09/06
 */
package org.seasar.tapestry;

import javax.servlet.ServletException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationServlet;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.request.RequestContext;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/**
 * @author maruo_syunsuke
 */
public class S2ApplicationServlet extends ApplicationServlet {
	private static final Log LOG = LogFactory
			.getLog(S2ApplicationServlet.class);

	protected IEngine createEngine(RequestContext context)
			throws ServletException {
		try {
			String className = getEngineClassName();

			if (LOG.isDebugEnabled())
				LOG.debug("Creating engine from class " + className);

			Class engineClass = getResourceResolver().findClass(className);

			S2Container container = SingletonS2ContainerFactory.getContainer();
			IEngine result ;
			if(container.hasComponentDef(engineClass)) {
				result = (IEngine) container.getComponent(engineClass);
			}else {
				result = (IEngine)engineClass.newInstance();
			}

			if (LOG.isDebugEnabled())
				LOG.debug("Created engine " + result);

			return result;
		} catch (Exception ex) {
			throw new ServletException(ex);
		}
	}
}