/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class BinaryDumpOutputStream
extends OutputStream {
    private PrintWriter out;
    private boolean locked = false;
    private boolean showOffset = true;
    private int bytesPerLine = 16;
    private int spacingInterval = 4;
    private char substituteChar = (char)46;
    private String offsetSeperator = ": ";
    private int offset = 0;
    private int lineCount = 0;
    private int bytesSinceSpace = 0;
    private char[] ascii = null;
    private boolean showAscii = true;
    private String asciiBegin = "  |";
    private String asciiEnd = "|";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public BinaryDumpOutputStream() {
        this(new PrintWriter(System.out, true));
    }

    public BinaryDumpOutputStream(PrintWriter out) {
        this.out = out;
    }

    public BinaryDumpOutputStream(Writer out) {
        this.out = new PrintWriter(out);
    }

    public void close() throws IOException {
        if (this.out != null) {
            if (this.lineCount > 0) {
                this.finishFinalLine();
            }
            this.out.close();
        }
        this.out = null;
    }

    private void finishFinalLine() {
        while (this.lineCount < this.bytesPerLine) {
            if (this.spacingInterval > 0 && this.bytesSinceSpace == this.spacingInterval) {
                this.out.print(' ');
                this.bytesSinceSpace = 0;
            }
            this.out.print("  ");
            if (this.showAscii) {
                this.ascii[this.lineCount] = 32;
            }
            ++this.lineCount;
            ++this.bytesSinceSpace;
        }
        if (this.showAscii) {
            this.out.print(this.asciiBegin);
            this.out.print(this.ascii);
            this.out.print(this.asciiEnd);
        }
        this.out.println();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public String getAsciiBegin() {
        return this.asciiBegin;
    }

    public String getAsciiEnd() {
        return this.asciiEnd;
    }

    public int getBytesPerLine() {
        return this.bytesPerLine;
    }

    public String getOffsetSeperator() {
        return this.offsetSeperator;
    }

    public boolean getShowAscii() {
        return this.showAscii;
    }

    public char getSubstituteChar() {
        return this.substituteChar;
    }

    public void setAsciiBegin(String value) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.asciiBegin = value;
    }

    public void setAsciiEnd(String value) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.asciiEnd = value;
    }

    public void setBytesPerLine(int value) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.bytesPerLine = value;
        this.ascii = null;
    }

    public void setOffsetSeperator(String value) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.offsetSeperator = value;
    }

    public void setShowAscii(boolean value) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.showAscii = value;
    }

    public void setSubstituteChar(char value) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.substituteChar = value;
    }

    public void write(int b) throws IOException {
        if (this.showAscii && this.ascii == null) {
            this.ascii = new char[this.bytesPerLine];
        }
        this.locked = true;
        if (this.lineCount == this.bytesPerLine) {
            if (this.showAscii) {
                this.out.print(this.asciiBegin);
                this.out.print(this.ascii);
                this.out.print(this.asciiEnd);
            }
            this.out.println();
            this.bytesSinceSpace = 0;
            this.lineCount = 0;
            this.offset += this.bytesPerLine;
        }
        if (this.lineCount == 0 && this.showOffset) {
            this.writeHex(this.offset, 4);
            this.out.print(this.offsetSeperator);
        }
        if (this.spacingInterval > 0 && this.bytesSinceSpace == this.spacingInterval) {
            this.out.print(' ');
            this.bytesSinceSpace = 0;
        }
        this.writeHex(b, 2);
        if (this.showAscii) {
            char letter = b < 32 | b > 127 ? this.substituteChar : (char)b;
            this.ascii[this.lineCount] = letter;
        }
        ++this.lineCount;
        ++this.bytesSinceSpace;
    }

    private void writeHex(int value, int digits) {
        int i = 0;
        while (i < digits) {
            int nybble = value >> 4 * (digits - i - 1) & 0xF;
            this.out.print(HEX[nybble]);
            ++i;
        }
    }
}

