/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.tapestry.Tapestry;

public class MultiKey
implements Externalizable {
    private static final long serialVersionUID = 4465448607415788806L;
    private static final int HASH_CODE_UNSET = -1;
    private transient int hashCode = -1;
    private Object[] keys;

    public MultiKey() {
    }

    public MultiKey(Object[] keys, boolean makeCopy) {
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException(Tapestry.getMessage("MultiKey.null-keys"));
        }
        if (keys[0] == null) {
            throw new IllegalArgumentException(Tapestry.getMessage("MultiKey.first-element-may-not-be-null"));
        }
        if (makeCopy) {
            this.keys = new Object[keys.length];
            System.arraycopy(keys, 0, this.keys, 0, keys.length);
        } else {
            this.keys = keys;
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.keys == null) {
            throw new IllegalStateException(Tapestry.getMessage("MultiKey.no-keys"));
        }
        try {
            MultiKey otherMulti = (MultiKey)other;
            if (this.keys.length != otherMulti.keys.length) {
                return false;
            }
            int i = 0;
            while (i < this.keys.length) {
                if (this.keys[i] != otherMulti.keys[i]) {
                    if (this.keys[i] == null || otherMulti.keys[i] == null) {
                        return false;
                    }
                    if (!this.keys[i].equals(otherMulti.keys[i])) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.keys[0].hashCode();
            int i = 1;
            while (i < this.keys.length) {
                if (this.keys[i] != null) {
                    this.hashCode ^= this.keys[i].hashCode();
                }
                ++i;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("MultiKey[");
        int i = 0;
        while (i < this.keys.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            if (this.keys[i] == null) {
                buffer.append("<null>");
            } else {
                buffer.append(this.keys[i]);
            }
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.keys.length);
        int i = 0;
        while (i < this.keys.length) {
            out.writeObject(this.keys[i]);
            ++i;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int count = in.readInt();
        this.keys = new Object[count];
        int i = 0;
        while (i < count) {
            this.keys[i] = in.readObject();
            ++i;
        }
    }
}

