/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance.javassist;

import java.util.HashMap;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.apache.tapestry.enhance.CodeGenerationException;

public class ClassMapping {
    private Map _objectTypeMap = new HashMap();
    private ClassPool _classPool;

    public ClassMapping(ClassPool classPool) {
        this._classPool = classPool;
        this.initialize();
    }

    protected void initialize() {
        this.recordType("boolean", CtClass.booleanType);
        this.recordType("short", CtClass.shortType);
        this.recordType("int", CtClass.intType);
        this.recordType("long", CtClass.longType);
        this.recordType("float", CtClass.floatType);
        this.recordType("double", CtClass.doubleType);
        this.recordType("char", CtClass.charType);
        this.recordType("byte", CtClass.byteType);
        try {
            this.loadType("boolean[]");
            this.loadType("short[]");
            this.loadType("int[]");
            this.loadType("long[]");
            this.loadType("float[]");
            this.loadType("double[]");
            this.loadType("char[]");
            this.loadType("byte[]");
            this.loadType("java.lang.Object");
            this.loadType("java.lang.Object[]");
            this.loadType("java.lang.String");
            this.loadType("java.lang.String[]");
        }
        catch (NotFoundException e) {
            throw new CodeGenerationException(e);
        }
    }

    public void loadType(String type) throws NotFoundException {
        CtClass objectType = this._classPool.get(type);
        this._objectTypeMap.put(type, objectType);
    }

    public void recordType(String type, CtClass objectType) {
        this._objectTypeMap.put(type, objectType);
    }

    public CtClass getType(String type) {
        return (CtClass)this._objectTypeMap.get(type);
    }
}

