/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.AbstractEngine;
import org.apache.tapestry.engine.IPageRecorder;
import org.apache.tapestry.record.SessionPageRecorder;

public class BaseEngine
extends AbstractEngine {
    private static final long serialVersionUID = -7051050643746333380L;
    private static final int MAP_SIZE = 3;
    private transient Map _recorders;
    private transient Set _activePageNames;

    protected void cleanupAfterRequest(IRequestCycle cycle) {
        if (Tapestry.isEmpty(this._recorders)) {
            return;
        }
        boolean markDirty = false;
        Iterator i = this._recorders.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String pageName = (String)entry.getKey();
            IPageRecorder recorder = (IPageRecorder)entry.getValue();
            if (recorder.getHasChanges() && !recorder.isMarkedForDiscard()) continue;
            recorder.discard();
            i.remove();
            this._activePageNames.remove(pageName);
            markDirty = true;
        }
        if (markDirty) {
            this.markDirty();
        }
    }

    public void forgetPage(String name) {
        if (this._recorders == null) {
            return;
        }
        IPageRecorder recorder = (IPageRecorder)this._recorders.get(name);
        if (recorder == null) {
            return;
        }
        if (recorder.isDirty()) {
            throw new ApplicationRuntimeException(Tapestry.format("BaseEngine.recorder-has-uncommited-changes", name));
        }
        recorder.discard();
        this._recorders.remove(name);
        this._activePageNames.remove(name);
        this.markDirty();
    }

    public Collection getActivePageNames() {
        if (this._activePageNames == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this._activePageNames);
    }

    public IPageRecorder getPageRecorder(String pageName, IRequestCycle cycle) {
        if (this._activePageNames == null || !this._activePageNames.contains(pageName)) {
            return null;
        }
        IPageRecorder result = null;
        if (this._recorders != null) {
            result = (IPageRecorder)this._recorders.get(pageName);
            return result;
        }
        if (result == null) {
            result = this.createPageRecorder(pageName, cycle);
        }
        return result;
    }

    public IPageRecorder createPageRecorder(String pageName, IRequestCycle cycle) {
        if (this._recorders == null) {
            this._recorders = new HashMap(3);
        } else if (this._recorders.containsKey(pageName)) {
            throw new ApplicationRuntimeException(Tapestry.format("BaseEngine.duplicate-page-recorder", pageName));
        }
        cycle.getRequestContext().createSession();
        this.setStateful();
        SessionPageRecorder result = new SessionPageRecorder();
        result.initialize(pageName, cycle);
        this._recorders.put(pageName, result);
        if (this._activePageNames == null) {
            this._activePageNames = new HashSet();
        }
        this._activePageNames.add(pageName);
        this.markDirty();
        return result;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int count = in.readInt();
        if (count > 0) {
            this._activePageNames = new HashSet(count);
        }
        int i = 0;
        while (i < count) {
            String name = in.readUTF();
            this._activePageNames.add(name);
            ++i;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (Tapestry.isEmpty(this._activePageNames)) {
            out.writeInt(0);
            return;
        }
        int count = this._activePageNames.size();
        out.writeInt(count);
        Iterator i = this._activePageNames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            out.writeUTF(name);
        }
    }

    public void extendDescription(ToStringBuilder builder) {
        builder.append("activePageNames", (Object)this._activePageNames);
    }
}

