/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.asset;

import java.io.InputStream;
import java.net.URL;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.asset.AbstractAsset;
import org.apache.tapestry.asset.AssetExternalizer;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.resource.ClasspathResourceLocation;

public class PrivateAsset
extends AbstractAsset {
    private AssetExternalizer _externalizer;

    public PrivateAsset(ClasspathResourceLocation resourceLocation, ILocation location) {
        super(resourceLocation, location);
    }

    public String buildURL(IRequestCycle cycle) {
        String path;
        String externalURL;
        if (this._externalizer == null) {
            this._externalizer = AssetExternalizer.get(cycle);
        }
        if ((externalURL = this._externalizer.getURL(path = this.getResourceLocation().getPath())) != null) {
            return externalURL;
        }
        Object[] parameters = new String[]{path};
        IEngineService service = cycle.getEngine().getService("asset");
        ILink link = service.getLink(cycle, null, parameters);
        return link.getURL();
    }

    public InputStream getResourceAsStream(IRequestCycle cycle) {
        IResourceLocation location = this.getResourceLocation();
        try {
            URL url = location.getResourceURL();
            return url.openStream();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("PrivateAsset.resource-missing", location), ex);
        }
    }
}

