package org.seasar.dao.impl;

import javax.sql.DataSource;

import org.seasar.dao.BeanMetaData;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.util.IntegerConversionUtil;

/**
 * @author higa
 *  
 */
public class UpdateAutoStaticCommand extends AbstractAutoStaticCommand {

	public UpdateAutoStaticCommand(DataSource dataSource,
			BeanMetaData beanMetaData) {

		super(dataSource, beanMetaData);
	}

	protected AbstractAutoHandler createAutoHandler() {
		return new UpdateAutoHandler(getDataSource(), getBeanMetaData());
	}

	public Object execute(Object[] args) {
		Object ret = super.execute(args);
		BeanMetaData bmd = getBeanMetaData();
		if (bmd.hasVersionNoPropertyType()) {
			PropertyDesc pd = bmd.getVersionNoPropertyType().getPropertyDesc();
			Object value = pd.getValue(args[0]);
			int intValue = IntegerConversionUtil.toPrimitiveInt(value) + 1;
			pd.setValue(args[0], new Integer(intValue));
		}
		return ret;
	}
}