package org.seasar.framework.message;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/**
 * @author higa
 *
 * bZ[WR[hƈvpeBɓo^Ă
 * p^[ɓKpAbZ[WgݗĂ܂B<br />
 * bZ[WR[h́A8ō\
 * ŏ1bZ[W̎ʂŁAE:G[AW:[jOAI:CtH[Vō\܂B<br />
 * 3VXeSeasaȑꍇ́ASSRɂȂ܂B<br />
 * Ō4́AAԂłB<br />
 * bZ[W`t@ĆAVXe + Messages.propertiesɂȂ܂B<br /
 * SSRMessages_ja.propertiesȂǂpӂ邱ƂőɑΉł܂B
 */

public final class MessageFormatter {

	private static final String MESSAGES = "Messages";

	private MessageFormatter() {
	}

	public static String getMessage(String messageCode, Object[] args) {
		if (messageCode == null) {
			messageCode = "";
		}
		return "[" + messageCode + "]" + getSimpleMessage(messageCode, args);
	}

	public static String getSimpleMessage(
		String messageCode,
		Object[] arguments) {
			
		try {
			String pattern = getPattern(messageCode);
			if (pattern != null) {
				return MessageFormat.format(pattern, arguments);
			}
		} catch (Throwable ignore) {
		}
		return getNoPatternMessage(arguments);
	}
	
	private static String getPattern(String messageCode) {
		ResourceBundle resourceBundle =
			getMessages(getSystemName(messageCode));
		if (resourceBundle != null) {
			return resourceBundle.getString(messageCode);
		}
		return null;
	}
	
	private static String getSystemName(String messageCode) {
		return messageCode.substring(1, Math.min(4, messageCode.length()));
	}
	
	private static ResourceBundle getMessages(String systemName) {
		return ResourceBundle.getBundle(systemName + MESSAGES);
	}
	
	private static String getNoPatternMessage(Object[] args) {
		if (args == null || args.length == 0) {
			return "";
		}
		StringBuffer buffer = new StringBuffer();
		for (int i = 0; i < args.length; i++) {
			buffer.append(args[i] + ", ");
		}
		buffer.setLength(buffer.length() - 2);
		return buffer.toString();
	}
}