package org.seasar.framework.container.impl;

import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.util.OgnlUtil;

/**
 * @author higa
 *
 */
public class ArgDefImpl implements ArgDef {

	private Object value_;
	private S2Container container_;
	private String expression_;
	private Object exp_;
	private ComponentDef childComponentDef_;

	public ArgDefImpl() {
	}
	
	public ArgDefImpl(Object value) {
		setValue(value);
	}

	/**
	 * @see org.seasar.framework.container.ConstructorArgDef#getReturnValue()
	 */
	public final Object getValue() {
		if (exp_ != null) {
			return OgnlUtil.getValue(exp_, container_);
		}
		if (childComponentDef_ != null) {
			return childComponentDef_.getComponent();
		}
		return value_;
	}

	public final void setValue(Object value) {
		value_ = value;
	}
	
	/**
	 * @see org.seasar.framework.container.ArgDef#getContainer()
	 */
	public final S2Container getContainer() {
		return container_;
	}

	/**
	 * @see org.seasar.framework.container.ArgDef#setContainer(org.seasar.framework.container.S2Container)
	 */
	public final void setContainer(S2Container container) {
		container_ = container;
		if (childComponentDef_ != null) {
			childComponentDef_.setContainer(container);
		}
	}

	/**
	 * @see org.seasar.framework.container.ArgDef#getExpression()
	 */
	public final String getExpression() {
		return expression_;
	}
	/**
	 * @see org.seasar.framework.container.ArgDef#setExpression(java.lang.String)
	 */
	public final void setExpression(String expression) {
		expression_ = expression;
		exp_ = OgnlUtil.parseExpression(expression);
	}

	/**
	 * @see org.seasar.framework.container.ArgDef#setChildComponentDef(org.seasar.framework.container.ComponentDef)
	 */
	public final void setChildComponentDef(ComponentDef componentDef) {
		if (container_ != null) {
			componentDef.setContainer(container_);
		}
		childComponentDef_ = componentDef;
	}
}
