package org.seasar.struts;

import org.apache.struts.action.ActionMapping;
import org.seasar.framework.container.S2Container;

/**
 * @see org.seasar.struts.ComponentNameCreator
 * @author Satoshi Kimura
 */
public class ComponentNameCreatorImpl implements ComponentNameCreator {

    /**
     * ActionMappingR|[lgA쐬B <br>
     * R|[lg鏇Ԃ́A
     * <UL>
     * <LI>module(prefix)+path</LI>
     * <LI>path</LI>
     * </UL>
     * ƂȂB
     * 
     * @see org.seasar.struts.ComponentNameCreator#createComponentName(org.seasar.framework.container.S2Container,
     *      org.apache.struts.action.ActionMapping)
     */
    public String createComponentName(S2Container container, ActionMapping mapping) {
        String moduleName = mapping.getModuleConfig().getPrefix();
        String path = mapping.getPath();

        String componentName = moduleName + path;
        if (false == container.hasComponentDef(componentName)) {
            componentName = path;
        }
        return componentName;
    }
}