package org.seasar.framework.container.impl;

import org.seasar.framework.container.S2Container;

/**
 * @author higa
 *
 */
public final class S2ContainerManager {

	private static ThreadLocal threadLocal_ = new ThreadLocal();
	
	private S2ContainerManager() {
	}
	
	public static S2Container getRoot() {
		return (S2Container) threadLocal_.get();
	}
	
	public static boolean hasRoot() {
		return threadLocal_.get() != null;
	}
	
	public static void setRoot(S2Container root) {
		threadLocal_.set(root);
	}

}
