package org.seasar.dao.interceptors;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;

import javax.sql.DataSource;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.Dbms;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.impl.DaoMetaDataFactory;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.DatabaseMetaDataUtil;
import org.seasar.framework.util.MethodUtil;

/**
 * @author higa
 *
 */
public class S2DaoInterceptor extends AbstractInterceptor {

	private DataSource dataSource_;
	private Dbms dbms_;
	
	public S2DaoInterceptor(DataSource dataSource) {
		dataSource_ = dataSource;
		setupDbms();
	}
	
	private void setupDbms() {
		Connection con = DataSourceUtil.getConnection(dataSource_);
		try {
			DatabaseMetaData dmd = ConnectionUtil.getMetaData(con);
			dbms_ = DbmsManager.getDbms(DatabaseMetaDataUtil.getDatabaseProductName(dmd));
		} finally {
			ConnectionUtil.close(con);
		}
	}

	/**
	 * @see org.aopalliance.intercept.MethodInterceptor#invoke(org.aopalliance.intercept.MethodInvocation)
	 */
	public Object invoke(MethodInvocation invocation) throws Throwable {
		Method method = invocation.getMethod();
		if (!MethodUtil.isAbstract(method)) {
			return invocation.proceed();
		}
		Class daoClass = getTargetClass(invocation);
		DaoMetaData dmd = DaoMetaDataFactory.getDaoMetaData(daoClass, dbms_, dataSource_);
		SqlCommand cmd = dmd.getSqlCommand(method.getName()); 
		return cmd.execute(dataSource_, invocation.getArguments());
	}
}
