package org.seasar.dao.impl;

import org.seasar.dao.CommandContext;
import org.seasar.dao.Node;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.context.CommandContextImpl;
import org.seasar.dao.parser.SqlParserImpl;

/**
 * @author higa
 *  
 */
public abstract class AbstractDynamicCommand implements SqlCommand {

	private String sql_;
	private Node rootNode_;
	private String[] argNames_ = new String[0];

	public AbstractDynamicCommand() {
	}

	public String getSql() {
		return sql_;
	}

	public void setSql(String sql) {
		sql_ = sql;
		rootNode_ = new SqlParserImpl(sql).parse();
	}

	public String[] getArgNames() {
		return argNames_;
	}

	public void setArgNames(String[] argNames) {
		argNames_ = argNames;
	}

	protected CommandContext apply(Object[] args) {
		CommandContext ctx = createCommandContext(args);
		rootNode_.accept(ctx);
		return ctx;
	}

	protected CommandContext createCommandContext(Object[] args) {
		CommandContext ctx = new CommandContextImpl();
		if (argNames_.length == 0 && args.length == 1) {
			ctx.addArg("$1", args[0]);
		}
		for (int i = 0; i < argNames_.length; ++i) {
			if (i < args.length) {
				ctx.addArg(argNames_[i], args[i]);
			} else {
				ctx.addArg(argNames_[i], null);
			}
		}
		return ctx;
	}
}