package test.org.seasar.dao.impl;

import java.util.List;

import org.seasar.dao.BeanMetaData;
import org.seasar.dao.impl.BeanListMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanMetaDataFactory;
import org.seasar.dao.impl.SelectDynamicAutoCommand;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.unit.S2TestCase;

public class SelectDynamicAutoCommandTest extends S2TestCase {

	private static BeanMetaData beanMetaData_ = BeanMetaDataFactory.getBeanMetaData(Employee.class);
	private static ResultSetHandler resultSetHandler_ =
		new BeanListMetaDataResultSetHandler(Employee.class);

	public SelectDynamicAutoCommandTest(String arg0) {
		super(arg0);
	}

	public void testExecute() throws Exception {
		SelectDynamicAutoCommand cmd = new SelectDynamicAutoCommand(
				beanMetaData_, resultSetHandler_);
		List employees = (List) cmd.execute(getDataSource(), new Object[0]);
		System.out.println(employees);
		assertNotNull("1", employees);
	}
	
	public void testExecute2() throws Exception {
		SelectDynamicAutoCommand cmd = new SelectDynamicAutoCommand(
				beanMetaData_, resultSetHandler_);
		cmd.setArgNames(new String[]{"empno"});
		System.out.println(cmd.execute(getDataSource(), new Object[]{new Integer(7788)}));
		System.out.println(cmd.execute(getDataSource(), new Object[]{null}));
	}
	
	public void testExecute3() throws Exception {
		SelectDynamicAutoCommand cmd = new SelectDynamicAutoCommand(
				beanMetaData_, resultSetHandler_);
		cmd.setArgNames(new String[]{"ename", "dname_0"});
		System.out.println(cmd.execute(getDataSource(), new Object[]{null, null}));
		System.out.println(cmd.execute(getDataSource(), new Object[]{null, "SALES"}));
		System.out.println(cmd.execute(getDataSource(), new Object[]{"WARD", null}));
		System.out.println(cmd.execute(getDataSource(), new Object[]{"WARD", "SALES"}));
	}

	public void setUp() {
		include("j2ee.dicon");
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(SelectDynamicAutoCommandTest.class);
	}

}
