package org.seasar.dao.impl;

import javax.sql.DataSource;

import org.seasar.dao.BeanMetaData;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.SelectHandler;

/**
 * @author higa
 *  
 */
public class SelectDynamicCommand extends AbstractDynamicCommand {

	private BeanMetaData beanMetaData_;

	private ResultSetHandler resultSetHandler_;

	public SelectDynamicCommand(BeanMetaData beanMetaData,
			ResultSetHandler resultSetHandler) {

		beanMetaData_ = beanMetaData;
		resultSetHandler_ = resultSetHandler;
	}
	
	public BeanMetaData getBeanMetaData() {
		return beanMetaData_;
	}

	public ResultSetHandler getResultSetHandler() {
		return resultSetHandler_;
	}

	public Object execute(DataSource ds, Object[] args) {
		SelectHandler selectHandler = createSelectHandler(ds);
		return selectHandler.execute(args);
	}
	
	protected SelectHandler createSelectHandler(DataSource ds) {
		return new SelectDynamicHandler(ds,
				resultSetHandler_, beanMetaData_, this);
	}

}