package org.seasar.dao.impl;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.seasar.dao.BeanMetaData;
import org.seasar.dao.dialect.DialectManager;
import org.seasar.extension.jdbc.ResultSetHandler;

/**
 * @author higa
 *
 */
public class SelectDynamicAutoHandler extends SelectDynamicHandler {

	/**
	 * @param dataSource
	 * @param resultSetHandler
	 * @param beanMetaData
	 * @param selectDynamicCommand
	 */
	public SelectDynamicAutoHandler(DataSource dataSource,
			ResultSetHandler resultSetHandler, BeanMetaData beanMetaData,
			SelectDynamicCommand selectDynamicCommand) {

		super(dataSource, resultSetHandler, beanMetaData, selectDynamicCommand);
	}

	/**
	 * @see org.seasar.dao.impl.SelectDynamicHandler#setupMetaData(java.sql.DatabaseMetaData)
	 */
	protected void setupMetaData(DatabaseMetaData dbMetaData)
			throws SQLException {

		super.setupMetaData(dbMetaData);
		DialectManager.setupDialect(dbMetaData.getDatabaseProductName());
	}
}
