package org.seasar.dao.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import ognl.OgnlRuntime;

import org.seasar.dao.CommandContext;
import org.seasar.dao.ognl.CommandContextPropertyAccessor;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.CaseInsensitiveMap;

/**
 * @author higa
 *  
 */
public class CommandContextImpl implements CommandContext {

	private Map args_ = new CaseInsensitiveMap();
	private StringBuffer sqlBuf_ = new StringBuffer(100);
	private List bindVariables_ = new ArrayList();
	private boolean enabled_ = true;
	private CommandContext parent_;

	static {
		OgnlRuntime.setPropertyAccessor(CommandContext.class,
				new CommandContextPropertyAccessor());
	}

	public CommandContextImpl() {
	}

	public CommandContextImpl(CommandContext parent) {
		parent_ = parent;
		enabled_ = false;
	}

	/**
	 * @see org.seasar.dao.CommandContext#getArg(java.lang.String)
	 */
	public Object getArg(String name) {
		if (args_.containsKey(name)) {
			return args_.get(name);
		} else if (parent_ != null) {
			return parent_.getArg(name);
		} else {
			String message = MessageFormatter.getSimpleMessage("WDAO0001",
					new Object[]{name});
			System.out.println(message);
			return null;
		}
	}

	/**
	 * @see org.seasar.dao.CommandContext#addArg(java.lang.String,
	 *      java.lang.Object)
	 */
	public void addArg(String name, Object arg) {
		args_.put(name, arg);
	}

	/**
	 * @see org.seasar.dao.CommandContext#getSql()
	 */
	public String getSql() {
		return sqlBuf_.toString();
	}

	/**
	 * @see org.seasar.dao.CommandContext#getBindVariables()
	 */
	public Object[] getBindVariables() {
		return (Object[]) bindVariables_.toArray(new Object[bindVariables_
				.size()]);
	}

	/**
	 * @see org.seasar.dao.CommandContext#addSql(java.lang.String)
	 */
	public CommandContext addSql(String sql) {
		sqlBuf_.append(sql);
		return this;
	}

	/**
	 * @see org.seasar.dao.CommandContext#addSql(java.lang.String,
	 *      java.lang.Object)
	 */
	public CommandContext addSql(String sql, Object bindVariable) {
		sqlBuf_.append(sql);
		bindVariables_.add(bindVariable);
		return this;
	}

	/**
	 * @see org.seasar.dao.CommandContext#addSql(java.lang.String,
	 *      java.lang.Object[])
	 */
	public CommandContext addSql(String sql, Object[] bindVariables) {
		sqlBuf_.append(sql);
		for (int i = 0; i < bindVariables.length; ++i) {
			bindVariables_.add(bindVariables[i]);
		}
		return this;
	}

	/**
	 * @see org.seasar.dao.CommandContext#isEnabled()
	 */
	public boolean isEnabled() {
		return enabled_;
	}

	/**
	 * @see org.seasar.dao.CommandContext#setEnabled(boolean)
	 */
	public void setEnabled(boolean enabled) {
		enabled_ = enabled;
	}
}