import sdl4gcj.SDLSystem;
import sdl4gcj.SDLConstants;
import sdl4gcj.SDLException;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;

public class PixelsArrayTest implements SDLConstants
{
	static final int BRUSH_SIZE = 64;

	public static void main(String[] args)
	{
		SDLSystem.init(SDLSystem.SDL_INIT_VIDEO);
		try
		{
			Screen screen = Screen.setVideoMode(640, 480, 32, SDL_SWSURFACE);

			// create white gradation brush surface
			int[] pixels = new int[BRUSH_SIZE*BRUSH_SIZE];
			Surface brush = Surface.createRGBSurfaceFrom(pixels,
				BRUSH_SIZE, BRUSH_SIZE, 32, BRUSH_SIZE*4,
				0x00ff0000, 0x0000ff00, 0x000000ff, 0xff000000);
			int radius = BRUSH_SIZE/2;
			for (int y = 0;y < BRUSH_SIZE;y++)
			{
				int offset = BRUSH_SIZE * y;
				for (int x = 0;x < BRUSH_SIZE;x++) 
				{
					int alpha = 0x7f - 0x7f * ((radius-x) * (radius-x) + (radius-y) * (radius-y)) / (radius * radius);
					if (alpha < 0) alpha = 0;
					pixels[offset+x] = brush.mapRGBA(0xff, 0xff, 0xff, alpha);
				}
			}
			brush.displayFormatAlpha();

			// load and draw background image
			Surface bg = Surface.loadBMP("images/logo.bmp");
			screen.repeatSurface(bg);
			screen.flip();

			// event loop
			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				int x, y;
				event.waitEvent();
				switch (event.type)
				{
					case SDL_MOUSEMOTION :
						if (Mouse.getMouse().getButtonState(SDL_BUTTON_LEFT))
						{
							x = event.motion.x - radius;
							y = event.motion.y - radius;
							screen.blitSurface(brush, x, y);
							screen.updateRect();
						}
						break;
					case SDL_MOUSEBUTTONDOWN :
						x = event.buttondown.x - radius;
						y = event.buttondown.y - radius;
						screen.blitSurface(brush, x, y);
						screen.updateRect(x, y, BRUSH_SIZE, BRUSH_SIZE);
						break;
					case SDLEvent.SDL_KEYDOWN :
						if (event.keydown.sym == Keyboard.SDLK_ESCAPE ||
							event.keydown.sym == Keyboard.SDLK_q)
							done = true;
						break;
					case SDLEvent.SDL_QUIT:
						done = true;
						break;
					default:
						break;
				}
			}
		}
		finally
		{
			SDLSystem.quit();
		}
	}
}
