import sdl4gcj.video.*;

public class ImageFont
{
	static final String DEFAULT_FONT_FILE_NAME = "images/font-16x32.bmp";
	static final int DEFAULT_WIDTH = 16;
	static final int DEFAULT_HEIGHT = 32;

	private String fontFileName;
	private int width;
	private int height;

	private Surface fontSurface = null;

	public ImageFont(String fontFileName, int width, int height)
	{
		this.fontFileName = fontFileName;
		this.width = width;
		this.height = height;
	}

	public ImageFont()
	{
		this(DEFAULT_FONT_FILE_NAME, DEFAULT_WIDTH, DEFAULT_HEIGHT);
	}

	public Surface getFontSurface() 
	{
		if (fontSurface == null)
		{
			this.fontSurface = Surface.loadBMP(this.fontFileName);
			this.fontSurface.setColorKey();
		}
		return this.fontSurface; 
	}

	public void draw(Surface targetSurface, CharSequence string, int destX, int destY)
	{
		if(targetSurface == null || string == null) return;
		Surface srcSurface = this.getFontSurface();
		int charPerLine = srcSurface.getW() / width;
		int length = string.length();
		for (int i = 0;i < length;i++)
		{
			char c = string.charAt(i);
			if (c >= 0x20 && c <= 0x7E)
			{
				int index = (c - 0x20);
				int x =  (index % charPerLine) * this.width;
				int y =  (index / charPerLine) * this.height;
				targetSurface.blitSurface(srcSurface, x, y, 
					this.width, this.height, destX + (this.width * i), destY);
			}
		}
	}

	public int getStringWidth(CharSequence string)
	{
		return this.getWidth() * string.length();
	}

	public int getWidth() { return width; }
	public int getHeight() { return height; }

}
