/************************************************************
* Copyright 2005 Masahiko SAWAI All Rights Reserved. 
* sdl4gcj API invocation from C++ program.
************************************************************/
#include <stdio.h>
#include <gcj/cni.h>

#include <java/lang/Throwable.h>
#include <java/lang/String.h>
#include <java/lang/System.h>
#include <java/io/PrintStream.h>
#include <sdl4gcj/SDLSystem.h>
#include <sdl4gcj/SDLSystemConstants.h>
#include <sdl4gcj/event/EventConstants.h>
#include <sdl4gcj/event/EventManager.h>
#include <sdl4gcj/event/KeyboardEvent.h>
#include <sdl4gcj/event/MouseMotionEvent.h>
#include <sdl4gcj/input/KeyboardConstants.h>
#include <sdl4gcj/input/MouseConstants.h>
#include <sdl4gcj/input/Mouse.h>
#include <sdl4gcj/video/Color.h>
#include <sdl4gcj/video/Screen.h>
#include <sdl4gcj/video/VideoConstants.h>

using namespace ::java::lang;
using namespace ::sdl4gcj::event;
using namespace ::sdl4gcj::input;
using namespace ::sdl4gcj::video;
using namespace ::sdl4gcj;

int main(int argc, char* argv[])
{
	try
	{
		JvCreateJavaVM(NULL);
		JvAttachCurrentThread(NULL, NULL);

		SDLSystem::init(SDLSystemConstants::SDL_INIT_VIDEO);
		Screen* screen = Screen::setVideoMode(640, 480, 24,
			VideoConstants::SDL_SWSURFACE|VideoConstants::SDL_ANYFORMAT);

		Surface* icon = Surface::loadBMP(JvNewStringLatin1("images/icon.bmp"));
		icon->setColorKey();
		icon->displayFormat();

		JvInitClass(&Color::class$);
		screen->fillRect(screen->mapRGB(Color::BLACK));
		screen->updateRect();

		bool done = false;
		EventManager* event = new EventManager();
		while (!done)
		{
			event->pollEvent();
			switch (event->type)
			{
			case EventConstants::SDL_QUIT :
				done = true;
				break;
			case EventConstants::SDL_KEYDOWN :
				if ((event->keydown->sym == KeyboardConstants::SDLK_q) ||
					(event->keydown->sym == KeyboardConstants::SDLK_ESCAPE))
				{
					done = true;
				}
				break;
			case EventConstants::SDL_MOUSEMOTION :
				if (Mouse::getMouse()->getButtonState(MouseConstants::SDL_BUTTON_LEFT))
				{
					screen->blitSurface(icon, event->motion->x, event->motion->y);
					screen->updateRect();
				}
				break;
			default:
				break;
			}
		}

		SDLSystem::quit();
		JvDetachCurrentThread();
	}
	catch (Throwable* t)
	{
		t->printStackTrace();
	}
	return 0;
}
