/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#include "sdl4gcj/video/VideoInfo.h"
#include "sdl4gcj/video/PixelFormat.h"

#include <gcj/cni.h>
#include <SDL.h>


using namespace sdl4gcj::video;

jint 
VideoInfo::getHWAvailable ()
{
	SDL_VideoInfo* vinfo = (SDL_VideoInfo*)implementation;
	return (jint)vinfo->hw_available;
}

jint 
VideoInfo::getWMAvailable ()
{
	SDL_VideoInfo* vinfo = (SDL_VideoInfo*)implementation;
	return (jint)vinfo->wm_available;
}

jint 
VideoInfo::getBlitHW ()
{
	SDL_VideoInfo* vinfo = (SDL_VideoInfo*)implementation;
	return (jint)vinfo->blit_hw;
}

jint 
VideoInfo::getBlitHWCC ()
{
	SDL_VideoInfo* vinfo = (SDL_VideoInfo*)implementation;
	return (jint)vinfo->blit_hw_CC;
}

jint 
VideoInfo::getBlitHWA ()
{
	SDL_VideoInfo* vinfo = (SDL_VideoInfo*)implementation;
	return (jint)vinfo->blit_hw_A;
}

jint 
VideoInfo::getBlitSW ()
{
	SDL_VideoInfo* vinfo = (SDL_VideoInfo*)implementation;
	return (jint)vinfo->blit_sw;
}

jint 
VideoInfo::getBlitSWCC ()
{
	SDL_VideoInfo* vinfo = (SDL_VideoInfo*)implementation;
	return (jint)vinfo->blit_sw_CC;
}

jint 
VideoInfo::getBlitSWA ()
{
	SDL_VideoInfo* vinfo = (SDL_VideoInfo*)implementation;
	return (jint)vinfo->blit_sw_A;
}

jint 
VideoInfo::getBlitFill ()
{
	SDL_VideoInfo* vinfo = (SDL_VideoInfo*)implementation;
	return (jint)vinfo->blit_fill;
}

jint 
VideoInfo::getVideoMemory ()
{
	SDL_VideoInfo* vinfo = (SDL_VideoInfo*)implementation;
	return (jint)vinfo->video_mem;
}

PixelFormat *
VideoInfo::getVideoFormat ()
{
	if (this->videoFormat == NULL)
	{
		SDL_VideoInfo* vinfo = (SDL_VideoInfo*)implementation;
		this->videoFormat = new PixelFormat();
		this->videoFormat->implementation = (::gnu::gcj::RawData*)(vinfo->vfmt);
	}
	
	return this->videoFormat;
}
