/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.input;

public class Keyboard implements KeyboardConstants
{
	// class variables
	private static Keyboard singleton = null;

	// class methods
	public static Keyboard getKeyboard()
	{
		if (singleton == null)
		{
			singleton = new Keyboard();
		}
		return singleton;
	}

	public static native String getKeyName(int keysym);

	// constructor
	private Keyboard() 
	{ 
	}

	// instance methods
	public native byte[] getKeyStates();
	public native boolean getKeyState(int keysym);
	public native int getModState();
	public native void setModState(int modState);
	public native int enableUNICODE(int enable);
	public native int enableKeyRepeat(int delay, int interval);

	private byte[] keyStates;
}

