/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#include "sdl4gcj/image/IMGSystem.h"

#include "sdl4gcj/Version.h"

#include <gcj/cni.h>
#include <java/lang/String.h>
#include <stdlib.h>
#include <SDL.h>
#include <SDL_image.h>


using namespace sdl4gcj::image;
using sdl4gcj::Version;

Version*
IMGSystem::compiledVersion()
{
	JvInitClass(&IMGSystem::class$);

	SDL_version nativeVersion;
	SDL_IMAGE_VERSION(&nativeVersion);

	Version* compiledVersion = new Version(
		nativeVersion.major,
		nativeVersion.minor,
		nativeVersion.patch);

	return compiledVersion;
}

Version*
IMGSystem::linkedVersion()
{
	JvInitClass(&IMGSystem::class$);

	const SDL_version* nativeVersion = IMG_Linked_Version();

	Version* linkedVersion = new Version(
		nativeVersion->major,
		nativeVersion->minor,
		nativeVersion->patch);

	return linkedVersion;
}

