/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.event;

public class MouseMotionEvent extends SDLEvent
{
	public short which;	/* The mouse device index */
	public short state;	/* The current button state */
	public int x, y;	/* The X/Y coordinates of the mouse */
	public short xrel;	/* The relative motion in the X direction */
	public short yrel;	/* The relative motion in the Y direction */

	public MouseMotionEvent()
	{
		this((short)0, (short)0, 0, 0, (short)0, (short)0);
	}

	public MouseMotionEvent(short which, short state,
		int x, int y, short xrel, short yrel)
	{
		super(SDL_MOUSEMOTION);
		this.which = which;
		this.state = state;
		this.x = x;
		this.y = y;
		this.xrel = xrel;
		this.yrel = yrel;
	}
}
