/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.event;
import gnu.gcj.RawData;

public final class EventManager implements EventConstants
{
	public int type;
	public SDLEvent lastEvent;
	private void setLastEvent(SDLEvent lastEvent) { this.lastEvent = lastEvent; }

	public final ActiveEvent active = new ActiveEvent();
	public final KeyboardEvent keydown = new KeyboardDownEvent();
	public final KeyboardEvent keyup = new KeyboardUpEvent();
	public final MouseMotionEvent motion = new MouseMotionEvent();
	public final MouseButtonEvent buttondown = new MouseButtonDownEvent();
	public final MouseButtonEvent buttonup = new MouseButtonUpEvent();
	public final JoyAxisEvent jaxis = new JoyAxisEvent();
	public final JoyBallEvent jball = new JoyBallEvent();
	public final JoyHatEvent jhat = new JoyHatEvent();
	public final JoyButtonEvent jbuttondown = new JoyButtonDownEvent();
	public final JoyButtonEvent jbuttonup = new JoyButtonUpEvent();
	public final QuitEvent quit = new QuitEvent();
	public final SysWMEvent syswm = new SysWMEvent();
	public final ResizeEvent resize = new ResizeEvent();
	public final ExposeEvent expose = new ExposeEvent();
	public final UserEvent user1 = new UserEvent(SDL_USEREVENT, 0);
	public final UserEvent user2 = new UserEvent(SDL_USEREVENT+1, 0);
	public final UserEvent user3 = new UserEvent(SDL_USEREVENT+2, 0);
	public final UserEvent user4 = new UserEvent(SDL_USEREVENT+3, 0);
	public final UserEvent user5 = new UserEvent(SDL_USEREVENT+4, 0);
	public final UserEvent user6 = new UserEvent(SDL_USEREVENT+5, 0);
	public final UserEvent user7 = new UserEvent(SDL_USEREVENT+6, 0);
	public final UserEvent user8 = new UserEvent(SDL_USEREVENT+7, 0);

	public EventManager()
	{
		this.type = SDL_NOEVENT;
	}

	public native void pushEvent(SDLEvent event);
	public native void pumpEvents();
	public native int pollEvent();
	public native int waitEvent();

	private native void setEvent(RawData rawEvent);
}

