import sdl4gcj.SDLSystem;
import sdl4gcj.SDLConstants;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;

public class RedGradationFilter implements SDLConstants
{
	public static void main(String[] args)
	{
		if (SDLSystem.init(SDLSystem.SDL_INIT_VIDEO) != 0)
		{
			System.out.println("init fail.");
			System.exit(0);
		}

		Screen screen = Screen.setVideoMode(640, 480, 32, SDL_SWSURFACE);

		// create red gradation filter surface
		int[] pixels = new int[screen.getW() * screen.getH()];
		Surface redGradation = Surface.createRGBSurfaceFrom(pixels,
			screen.getW(), screen.getH(), 32, screen.getW()*4,
			 0x00ff0000, 0x0000ff00, 0x000000ff, 0xff000000);
		int width = redGradation.getW();
		int height = redGradation.getH();
		for (int y = 0;y < height;y++)
		{
			int offset = width * y;
			for (int x = 0;x < width;x++) 
			{
				pixels[offset+x] = (redGradation.mapRGBA(0xff, 0, 0, 0xff * y / height));
			}
		}

		// load background image
		Surface bg = Surface.loadBMP("images/logo.bmp");

		// draw image and filter
		screen.repeatSurface(bg);
		screen.blitSurface(redGradation);
		screen.flip();

		// event loop
		boolean done = false;
		EventManager event = new EventManager();
		while (!done)
		{
			event.waitEvent();
			switch (event.type)
			{
				case SDLEvent.SDL_KEYDOWN :
					if (event.keydown.sym == Keyboard.SDLK_ESCAPE ||
						event.keydown.sym == Keyboard.SDLK_q)
						done = true;
					break;
				case SDLEvent.SDL_QUIT:
					done = true;
					break;
				default:
					break;
			}
		}

		SDLSystem.quit();
	}
}
