#include "sdl4gcj/video/Cursor.h"
#include "sdl4gcj/SDLException.h"

#include <gcj/cni.h>
#include <SDL.h>


using namespace sdl4gcj::video;


// function
static
inline
sdl4gcj::SDLException*
createInvalidCursorException()
{
	return new sdl4gcj::SDLException(JvNewStringLatin1("This Cursor was freed already"));
}

// class method
void 
Cursor::setCursor (Cursor *cursor)
{
	JvInitClass(&Cursor::class$);

	if (cursor->implementation == NULL) throw createInvalidCursorException();
	SDL_Cursor* nativeCursor = (SDL_Cursor*)cursor->implementation;
	SDL_SetCursor(nativeCursor);

	return ;
}

Cursor *
Cursor::getCursor ()
{
	JvInitClass(&Cursor::class$);

	SDL_Cursor* nativeCursor = SDL_GetCursor();
	if (nativeCursor == NULL) new SDLException();
	Cursor* cursor = new Cursor();
	cursor->implementation = (gnu::gcj::RawData*)nativeCursor;

	return cursor;
}

jboolean
Cursor::showCursor (jboolean toggle)
{
	JvInitClass(&Cursor::class$);

	return (SDL_ShowCursor(toggle ? SDL_ENABLE : SDL_DISABLE) == SDL_ENABLE);
}

void
Cursor::setVisible (jboolean toggle)
{
	JvInitClass(&Cursor::class$);

	SDL_ShowCursor(toggle ? SDL_ENABLE : SDL_DISABLE);
}

jboolean
Cursor::isVisible ()
{
	JvInitClass(&Cursor::class$);

	return (SDL_ShowCursor(SDL_QUERY) == SDL_ENABLE);
}


// instance method
void 
Cursor::initCursor (jbyteArray data, jbyteArray mask, 
	jint w, jint h, jint hotX, jint hotY)
{
	Uint8* nativeData = (Uint8*)elements(data);
	Uint8* nativeMask = (Uint8*)elements(mask);

	SDL_Cursor* nativeCursor = SDL_CreateCursor(nativeData, nativeMask, w, h, hotY, hotY);
	if (nativeCursor == NULL) throw new sdl4gcj::SDLException();
	this->implementation = (gnu::gcj::RawData*)nativeCursor;

	return ;
}

void
Cursor::freeCursor()
{
	if (this->implementation == NULL) throw createInvalidCursorException();
	SDL_Cursor* nativeCursor = (SDL_Cursor*)this->implementation;

	SDL_FreeCursor(nativeCursor);
	this->implementation = NULL;

	return ;
}
