#include "sdl4gcj/input/Joystick.h"
#include "sdl4gcj/SDLException.h"

#include <gcj/cni.h>
#include <SDL.h>


using namespace ::sdl4gcj::input;
using namespace ::java::lang;

// class methods
jint 
Joystick::getNumJoysticks ()
{
	JvInitClass(&Joystick::class$);
	return (jint)SDL_NumJoysticks();
}

jboolean 
Joystick::getEventState()
{
	JvInitClass(&Joystick::class$);
	return (SDL_JoystickEventState(SDL_QUERY) == SDL_ENABLE);
}

void 
Joystick::setEventState(jboolean state)
{
	JvInitClass(&Joystick::class$);
	SDL_JoystickEventState(state ? SDL_ENABLE : SDL_DISABLE);
}

void 
Joystick::update()
{
	JvInitClass(&Joystick::class$);
	SDL_JoystickUpdate();
}

// instance method
String *
Joystick::getName ()
{
	String *name = NULL;
	const char* nativeName = NULL;

	nativeName = SDL_JoystickName(this->getIndex());
	if (nativeName != NULL)
	{
		int bytesLength = strlen(nativeName);
		jbyteArray byteArray = JvNewByteArray(bytesLength+1);
		jbyte* bytes = elements(byteArray);
		strcpy((char*)bytes, nativeName);
		name = new String(byteArray);
	}

	return name;
}


jboolean 
Joystick::isOpened ()
{
	return this->implementation != NULL;
}

void 
Joystick::open ()
{
	if (!this->isOpened())
	{
		SDL_Joystick* nativeJoystick;
		nativeJoystick = SDL_JoystickOpen(this->getIndex());
		this->implementation = (::gnu::gcj::RawData*)nativeJoystick;
	}
}

void 
Joystick::close ()
{
	if (this->isOpened())
	{
		SDL_Joystick* nativeJoystick = (SDL_Joystick*)this->implementation;
		SDL_JoystickClose(nativeJoystick);
		this->implementation = NULL;
	}
}

jint 
Joystick::getNumAxes ()
{
	jint result = 0;

	if (!this->isOpened())
		throw Joystick::createNotOpenedException(this->getIndex(), this->getName());

	SDL_Joystick* nativeJoystick = (SDL_Joystick*)this->implementation;
	result = SDL_JoystickNumAxes(nativeJoystick);

	return result;
}

jint 
Joystick::getNumBalls ()
{
	jint result = 0;

	if (!this->isOpened())
		throw Joystick::createNotOpenedException(this->getIndex(), this->getName());

	SDL_Joystick* nativeJoystick = (SDL_Joystick*)this->implementation;
	result = SDL_JoystickNumBalls(nativeJoystick);

	return result;
}

jint 
Joystick::getNumHats ()
{
	jint result = 0;

	if (!this->isOpened())
		throw Joystick::createNotOpenedException(this->getIndex(), this->getName());

	SDL_Joystick* nativeJoystick = (SDL_Joystick*)this->implementation;
	result = SDL_JoystickNumHats(nativeJoystick);

	return result;
}

jint 
Joystick::getNumButtons ()
{
	jint result = 0;

	if (!this->isOpened())
		throw Joystick::createNotOpenedException(this->getIndex(), this->getName());

	SDL_Joystick* nativeJoystick = (SDL_Joystick*)this->implementation;
	result = SDL_JoystickNumButtons(nativeJoystick);

	return result;
}

jint 
Joystick::getAxis (jint axisIndex)
{
	jint result = 0;

	if (!this->isOpened())
		throw Joystick::createNotOpenedException(this->getIndex(), this->getName());

	SDL_Joystick* nativeJoystick = (SDL_Joystick*)this->implementation;
	result = SDL_JoystickGetAxis(nativeJoystick, axisIndex);

	return result;
}

jint 
Joystick::getBallDX (jint ballIndex)
{
	jint result = 0;
	int dx, dy;
	if (!this->isOpened())
		throw Joystick::createNotOpenedException(this->getIndex(), this->getName());

	SDL_Joystick* nativeJoystick = (SDL_Joystick*)this->implementation;
	SDL_JoystickGetBall(nativeJoystick, ballIndex, &dx, &dy);
	result = dx;

	return result;
}

jint 
Joystick::getBallDY (jint ballIndex)
{
	jint result = 0;
	int dx, dy;

	if (!this->isOpened())
		throw Joystick::createNotOpenedException(this->getIndex(), this->getName());

	SDL_Joystick* nativeJoystick = (SDL_Joystick*)this->implementation;
	SDL_JoystickGetBall(nativeJoystick, ballIndex, &dx, &dy);
	result = dy;

	return result;
}

jint 
Joystick::getHat (jint hatIndex)
{
	jint result = 0;

	if (!this->isOpened())
		throw Joystick::createNotOpenedException(this->getIndex(), this->getName());

	SDL_Joystick* nativeJoystick = (SDL_Joystick*)this->implementation;
	result = SDL_JoystickGetHat(nativeJoystick, hatIndex);

	return result;
}

jint 
Joystick::getButton (jint buttonIndex)
{
	jint result = 0;

	if (!this->isOpened())
		throw Joystick::createNotOpenedException(this->getIndex(), this->getName());

	SDL_Joystick* nativeJoystick = (SDL_Joystick*)this->implementation;
	result = SDL_JoystickGetButton(nativeJoystick, buttonIndex);

	return result;
}

