#include "sdl4gcj/image/Image.h"

#include "sdl4gcj/video/Surface.h"
#include "sdl4gcj/SDLException.h"

#include <gcj/cni.h>
#include <java/lang/String.h>
#include <stdlib.h>
#include <SDL.h>
#include <SDL_image.h>


using namespace sdl4gcj::image;
using sdl4gcj::video::Surface;


Surface *
Image::load(::java::lang::String* filePath)
{
	JvInitClass(&Image::class$);
	Surface* result = NULL;

	jbyteArray byteArray = filePath->getBytes();
	int length = JvGetArrayLength(byteArray);
	jbyte* bytes = elements(byteArray);
	char buffer[length+1];

	memcpy(buffer, bytes, length);
	buffer[length] = '\0';

	SDL_Surface* image = IMG_Load(buffer);
	if (image != NULL)
	{
		result = new Surface();
		result->implementation = (::gnu::gcj::RawData*)image;
	}

	return result;
}

Surface *
Image::load(JArray<jbyte>* byteArray, jint offset, jint length)
{
	JvInitClass(&Image::class$);
	Surface* result = NULL;
	jbyte* bytes = elements(byteArray) + offset;

	SDL_Surface* image = IMG_Load_RW(SDL_RWFromMem(bytes, length), 1);
	if (image != NULL)
	{
		result = new Surface();
		result->implementation = (::gnu::gcj::RawData*)image;
	}

	return result;
}

