import sdl4gcj.SDLSystem;
import sdl4gcj.SDLConstants;
import sdl4gcj.video.*;
import sdl4gcj.event.*;

public class VideoInfoTest
{
	public static void main(String[] args)
	{
		if (SDLSystem.init(SDLSystem.SDL_INIT_VIDEO) != 0)
		{
			System.out.println("SDL_Init() fail : " );
			System.exit(0);
		}

		try
		{
			VideoInfo videoInfo = Screen.getVideoInfo();
			PixelFormat videoFormat = videoInfo.getVideoFormat();

			System.out.println("Video driver : " + Surface.getVideoDriverName());
			System.out.println("videoInfo : " + videoInfo);
			
			Screen screen = Screen.setVideoMode(640, 480, 8, 
				Screen.SDL_SWSURFACE|Screen.SDL_ANYFORMAT);
			ImageFont font = new ImageFont("images/font-8x16.bmp", 8, 16);

			int x = 10;
			int y = 10;
			font.draw(screen, "Video Driver : " + Surface.getVideoDriverName(), x, y);
			y += font.getHeight() + 5;

			font.draw(screen, "HWAvailable  : " + videoInfo.getHWAvailable(), x, y);
			y += font.getHeight();
			font.draw(screen, "WMAvailable  : " + videoInfo.getWMAvailable(), x, y);
			y += font.getHeight();
			font.draw(screen, "BlitHW       : " + videoInfo.getBlitHW() , x, y);
			y += font.getHeight();
			font.draw(screen, "BlitHWCC     : " + videoInfo.getBlitHWCC() , x, y);
			y += font.getHeight();
			font.draw(screen, "BlitHWA      : " + videoInfo.getBlitHWA() , x, y);
			y += font.getHeight();
			font.draw(screen, "BlitSW       : " + videoInfo.getBlitSW() , x, y);
			y += font.getHeight();
			font.draw(screen, "BlitSWCC     : " + videoInfo.getBlitSWCC() , x, y);
			y += font.getHeight();
			font.draw(screen, "BlitSWA      : " + videoInfo.getBlitSWA() , x, y);
			y += font.getHeight();
			font.draw(screen, "BlitFill     : " + videoInfo.getBlitFill() , x, y);
			y += font.getHeight();
			font.draw(screen, "VideoMemory  : " + videoInfo.getVideoMemory() , x, y);

			x = 320;
			y = 10;
			font.draw(screen, "VideoFormat", x, y);
			y += font.getHeight() + 5;
			font.draw(screen, "BitsPerPixel  : " + videoFormat.getBitsPerPixel(), x, y);
			y += font.getHeight();
			font.draw(screen, "BytesPerPixel : " + videoFormat.getBytesPerPixel(), x, y);
			y += font.getHeight();
			font.draw(screen, "Rloss    : " + videoFormat.getRloss(), x, y);
			y += font.getHeight();
			font.draw(screen, "Gloss    : " + videoFormat.getGloss(), x, y);
			y += font.getHeight();
			font.draw(screen, "Bloss    : " + videoFormat.getBloss(), x, y);
			y += font.getHeight();
			font.draw(screen, "Rshift   : " + videoFormat.getRshift(), x, y);
			y += font.getHeight();
			font.draw(screen, "Gshift   : " + videoFormat.getGshift(), x, y);
			y += font.getHeight();
			font.draw(screen, "Bshift   : " + videoFormat.getBshift(), x, y);
			y += font.getHeight();
			font.draw(screen, "Rmask    : " + Integer.toHexString(videoFormat.getRmask()), x, y);
			y += font.getHeight();
			font.draw(screen, "Gmask    : " + Integer.toHexString(videoFormat.getGmask()), x, y);
			y += font.getHeight();
			font.draw(screen, "Bmask    : " + Integer.toHexString(videoFormat.getBmask()), x, y);
			y += font.getHeight();
			font.draw(screen, "Colorkey : " + videoFormat.getColorkey(), x, y);
			y += font.getHeight();
			font.draw(screen, "Alpha    : " + videoFormat.getAlpha(), x, y);

			screen.updateRect();

			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				event.waitEvent();
				switch (event.type)
				{
					case SDLEvent.SDL_QUIT:
						done = true;
						break;
					case SDLEvent.SDL_KEYDOWN:
						if ((event.keydown.sym == KeyboardEvent.SDLK_q) ||
							(event.keydown.sym == KeyboardEvent.SDLK_ESCAPE))
						{
							done = true;
						}
						break;
					default:
						break;
				}
			}
		}
		finally
		{
			SDLSystem.quit();
		}
	}
}
