import java.util.Random;
import sdl4gcj.SDLSystem;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;

public class FillTest
{
	public static void main(String[] args)
	{
		if (SDLSystem.init(SDLSystem.SDL_INIT_VIDEO) != 0)
		{
			System.out.println("Init() fail");
			System.exit(0);
		}

		SDLOptionParser optParser = new SDLOptionParser(
			640, 480, 8, 
			Surface.SDL_SWSURFACE|Surface.SDL_ANYFORMAT);
		optParser.parse(args);

		try
		{
			Random random = new Random(0xee);
			Screen screen = Screen.setVideoMode(
				optParser.getScreenWidth(), optParser.getScreenHeight(),
				optParser.getBitsPerPixel(),
				optParser.getVideoFlags());

			// make grayscale palette and set into screen
			if (screen.getPalette() != null)
			{
				Color[] colors = new Color[256];
				for (int i = 0;i < colors.length;i++) 
					colors[i] = new Color(i, i, i);
				screen.setPalette(colors);
			}

			int w, h, x, y, brightness;
			int frames = 0;
			boolean done = false;
			EventManager event = new EventManager();
			long totalTicks = SDLSystem.getTicks();
			while (!done)
			{
				long startTicks = SDLSystem.getTicks();
				while (event.pollEvent() > 0)
				{
					switch (event.type)
					{
						case SDLEvent.SDL_KEYDOWN :
							if ((event.keydown.sym == Keyboard.SDLK_ESCAPE) ||
								(event.keydown.sym == Keyboard.SDLK_q))
								done = true;
							break;
						case SDLEvent.SDL_QUIT:
							done = true;
							break;
						default:
							break;
					}
				}

				frames++;
				w = random.nextInt(screen.getW());
				h = random.nextInt(screen.getH());
				x = (screen.getW() - w) / 2;
				y = (screen.getH() - h) / 2;
				brightness = random.nextInt(0xff);
				screen.fillRect(x, y, w, h, screen.mapRGB(brightness, brightness, brightness));
				screen.updateRect(x, y, w, h);
			}

			totalTicks = SDLSystem.getTicks() - totalTicks;
			System.out.println(((double)frames * 1000)/totalTicks + " (Frame per Second)");
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			SDLSystem.quit();
		}
	}
}
