
import sdl4gcj.SDLSystem;
import sdl4gcj.SDLConstants;
import sdl4gcj.video.*;
import sdl4gcj.event.*;

import sdl4gcj.image.IMGSystem;
import sdl4gcj.image.Image;

public class ImageTest implements SDLConstants
{
	static final String BACKGROUND_FILE = "../test/images/logo.bmp";
	static final String DEFAULT_IMAGE_FILE = "images/logo.png";

	public static void main(String[] args)
	{
		if (SDLSystem.init(SDL_INIT_VIDEO) != 0) System.exit(0);

		System.out.println(" Compiled SDL_image Version : " + IMGSystem.compiledVersion());
		System.out.println("   Linked SDL_image Version : " + IMGSystem.linkedVersion());

		SDLOptionParser optParser = new SDLOptionParser(
			640, 480, 32, 
			Surface.SDL_SWSURFACE|Surface.SDL_ANYFORMAT);
		args = optParser.parse(args);

		String imageFile = DEFAULT_IMAGE_FILE;
		if (args.length >= 1) imageFile = args[0];

		try
		{
			Screen screen = Screen.setVideoMode(
				optParser.getScreenWidth(),
				optParser.getScreenHeight(),
				optParser.getBitsPerPixel(),
				optParser.getVideoFlags());

			Surface bg = Surface.loadBMP(BACKGROUND_FILE);
			Surface image = Image.load(imageFile);

			screen.fillRect(screen.mapRGB(0x0, 0x00, 0x0));
			screen.repeatSurface(bg);
			screen.repeatSurface(image);
			screen.updateRect();

			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				event.waitEvent();
				switch (event.type)
				{
				case SDL_KEYDOWN :
					switch (event.keydown.sym)
					{
					case SDLK_q :
					case SDLK_ESCAPE :
						done = true;
						break;
					}
					break;
				case SDL_QUIT :
					done = true;
					break;
				default:
					break;
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			System.out.println("Quit SDL system!");
			SDLSystem.quit();
		}

		return ;
	}
}

