/************************************************************
* Copyright 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#include "sdl4gcj/mixer/MixSystem.h"

#include "sdl4gcj/mixer/MixerConstants.h"
#include "sdl4gcj/Version.h"

#include <gcj/cni.h>
#include <gcj/javaprims.h>
#include <SDL_mixer.h>

using namespace sdl4gcj::mixer;

// function

// class methods

sdl4gcj::Version*
MixSystem::compiledVersion()
{
	JvInitClass(&MixSystem::class$);

	SDL_version nativeVersion;
	MIX_VERSION(&nativeVersion);

	sdl4gcj::Version* compiledVersion = new Version(
		nativeVersion.major,
		nativeVersion.minor,
		nativeVersion.patch);

	return compiledVersion;
}

sdl4gcj::Version*
MixSystem::linkedVersion()
{
	JvInitClass(&MixSystem::class$);

	const SDL_version* nativeVersion = Mix_Linked_Version();

	sdl4gcj::Version* linkedVersion = new Version(
		nativeVersion->major,
		nativeVersion->minor,
		nativeVersion->patch);

	return linkedVersion;
}



