#include "sdl4gcj/input/Mouse.h"
#include "sdl4gcj/input/MouseConstants.h"

#include <gcj/cni.h>
#include <SDL.h>

using namespace ::sdl4gcj::input;

void 
Mouse::warpMouse (jint x, jint y)
{
	SDL_WarpMouse(x, y);
}

jboolean 
Mouse::getButtonState (jint button)
{
	return (SDL_GetMouseState(NULL, NULL) & SDL_BUTTON(button));
}

jint
Mouse::getButtonStates ()
{
	return SDL_GetMouseState(NULL, NULL);
}

jint 
Mouse::getX ()
{
	int x;
	SDL_GetMouseState(&x, NULL);
	return (jint)x;
}

jint 
Mouse::getY ()
{
	int y;
	SDL_GetMouseState(NULL, &y);
	return (jint)y;
}


/************************************************************
jint 
Mouse::getRelativeX ()
{
	int x;
	SDL_GetRelativeMouseState(&x, NULL);
	return (jint)x;
}


jint 
Mouse::getRelativeY ()
{
	int y;
	SDL_GetRelativeMouseState(NULL, &y);
	return y;
}
************************************************************/

