#include "sdl4gcj/input/Keyboard.h"
#include "sdl4gcj/input/KeyboardConstants.h"

#include <gcj/cni.h>
#include <SDL.h>


using namespace ::sdl4gcj::input;

jbyteArray 
Keyboard::getKeyStates ()
{
	if (this->keyStates == NULL)
		this->keyStates = JvNewByteArray(KeyboardConstants::SDLK_LAST);

	jbyte* states = elements(this->keyStates);
	int number;
	Uint8* nativeKeyStates = SDL_GetKeyState(&number);
	memcpy(states, nativeKeyStates, sizeof(Uint8) * number);

	return this->keyStates;
}

jboolean 
Keyboard::getKeyState (jint keysym)
{
	int number;
	Uint8* nativeKeyStates;

	nativeKeyStates = SDL_GetKeyState(&number);

	return (nativeKeyStates[keysym] == 1);
}

jint 
Keyboard::getModState ()
{
	jint result = 0;

	result = SDL_GetModState();

	return result;
}

void 
Keyboard::setModState (jint state)
{
	SDL_SetModState((SDLMod)state);
}

jint 
Keyboard::enableUNICODE (jint enable)
{
	jint result = 0;
	
	result = SDL_EnableUNICODE(enable);

	return result;
}

jint 
Keyboard::enableKeyRepeat (jint delay, jint interval)
{
	jint result = 0;

	result = SDL_EnableKeyRepeat(delay, interval);

	return result;
}


::java::lang::String *
Keyboard::getKeyName (jint keysym)
{
	::java::lang::String* name = NULL;

	char* nativeName = SDL_GetKeyName((SDLKey)keysym);
	if (nativeName != NULL)
		name = JvNewStringLatin1(nativeName);

	return name;
}

