#include "sdl4gcj/SDLSystem.h"
#include "sdl4gcj/Version.h"
#include "sdl4gcj/video/Surface.h"

#include <gcj/cni.h>
#include <SDL.h>

jint 
sdl4gcj::SDLSystem::init (jint flags)
{
	JvInitClass(&sdl4gcj::SDLSystem::class$);
	jint result = SDL_Init(flags);
	return result;
}

jint 
sdl4gcj::SDLSystem::initSubSystem (jint flags)
{
	JvInitClass(&sdl4gcj::SDLSystem::class$);
	jint result = SDL_InitSubSystem(flags);
	return result;
}

jint 
sdl4gcj::SDLSystem::wasInit (jint flags)
{
	JvInitClass(&sdl4gcj::SDLSystem::class$);
	jint result = SDL_WasInit(flags);
	return result;
}

void 
sdl4gcj::SDLSystem::quitSubSystem (jint flags)
{
	JvInitClass(&sdl4gcj::SDLSystem::class$);
	SDL_QuitSubSystem(flags);
}


void 
sdl4gcj::SDLSystem::quit ()
{
	JvInitClass(&sdl4gcj::SDLSystem::class$);
	SDL_Quit();
}

sdl4gcj::Version*
sdl4gcj::SDLSystem::compiledVersion()
{
	JvInitClass(&sdl4gcj::SDLSystem::class$);

	SDL_version nativeVersion;
	SDL_VERSION(&nativeVersion);

	sdl4gcj::Version* compiledVersion = new Version(
		nativeVersion.major,
		nativeVersion.minor,
		nativeVersion.patch);

	return compiledVersion;
}

sdl4gcj::Version*
sdl4gcj::SDLSystem::linkedVersion()
{
	JvInitClass(&sdl4gcj::SDLSystem::class$);

	const SDL_version* nativeVersion = SDL_Linked_Version();

	sdl4gcj::Version* linkedVersion = new Version(
		nativeVersion->major,
		nativeVersion->minor,
		nativeVersion->patch);

	return linkedVersion;
}

void 
sdl4gcj::SDLSystem::delay (jlong ms)
{
	JvInitClass(&sdl4gcj::SDLSystem::class$);
	SDL_Delay(ms);
}

jlong 
sdl4gcj::SDLSystem::getTicks ()
{
	JvInitClass(&sdl4gcj::SDLSystem::class$);
	return SDL_GetTicks();
}

jint 
sdl4gcj::SDLSystem::byteOrder ()
{
	JvInitClass(&sdl4gcj::SDLSystem::class$);
	return SDL_BYTEORDER;
}

